/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.render;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe.IPipeFlowRenderer;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.lib.client.render.fluid.FluidRenderer;
import buildcraft.lib.client.render.fluid.FluidSpriteType;
import buildcraft.lib.misc.VecUtil;
import buildcraft.transport.pipe.Pipe;
import buildcraft.transport.pipe.flow.PipeFlowFluids;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum PipeFlowRendererFluids implements IPipeFlowRenderer<PipeFlowFluids>
{
    INSTANCE;


    @Override
    public void render(PipeFlowFluids flow, double x, double y, double z, float partialTicks, BufferBuilder vb) {
        FluidStack forRender = flow.getFluidStackForRender();
        if (forRender == null) {
            return;
        }
        Profiler prof = Minecraft.func_71410_x().field_71424_I;
        prof.func_76320_a("calc");
        boolean[] sides = new boolean[6];
        Arrays.fill(sides, true);
        double[] amounts = flow.getAmountsForRender(partialTicks);
        Vec3d[] offsets = flow.getOffsetsForRender(partialTicks);
        int blocklight = forRender.getFluid().getLuminosity(forRender);
        IPipeHolder holder = flow.pipe.getHolder();
        int combinedLight = holder.getPipeWorld().func_175626_b(holder.getPipePos(), blocklight);
        FluidRenderer.vertex.lighti(combinedLight);
        BufferBuilder fluidBuffer = Tessellator.func_178181_a().func_178180_c();
        fluidBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        fluidBuffer.func_178969_c(x, y, z);
        boolean gas = forRender.getFluid().isGaseous(forRender);
        boolean horizontal = false;
        boolean vertical = flow.pipe.isConnected(gas ? EnumFacing.DOWN : EnumFacing.UP);
        prof.func_76318_c("build");
        for (EnumFacing face : EnumFacing.field_82609_l) {
            Vec3d offset;
            double size = ((Pipe)flow.pipe).getConnectedDist(face);
            double amount = amounts[face.func_176745_a()];
            if (face.func_176740_k() != EnumFacing.Axis.Y) {
                horizontal |= flow.pipe.isConnected(face) && amount > 0.0;
            }
            Vec3d center = VecUtil.offset(new Vec3d(0.5, 0.5, 0.5), face, 0.245 + size / 2.0);
            Vec3d radius = new Vec3d(0.24, 0.24, 0.24);
            radius = VecUtil.replaceValue(radius, face.func_176740_k(), 0.005 + size / 2.0);
            if (face.func_176740_k() == EnumFacing.Axis.Y) {
                double perc = amount / (double)flow.capacity;
                perc = Math.sqrt(perc);
                radius = new Vec3d(perc * 0.24, radius.field_72448_b, perc * 0.24);
            }
            if ((offset = offsets[face.func_176745_a()]) == null) {
                offset = Vec3d.field_186680_a;
            }
            center = center.func_178787_e(offset);
            fluidBuffer.func_178969_c(x - offset.field_72450_a, y - offset.field_72448_b, z - offset.field_72449_c);
            Vec3d min = center.func_178788_d(radius);
            Vec3d max = center.func_178787_e(radius);
            if (face.func_176740_k() == EnumFacing.Axis.Y) {
                FluidRenderer.renderFluid(FluidSpriteType.FROZEN, forRender, 1.0, 1.0, min, max, fluidBuffer, sides);
                continue;
            }
            FluidRenderer.renderFluid(FluidSpriteType.FROZEN, forRender, amount, flow.capacity, min, max, fluidBuffer, sides);
        }
        double amount = amounts[EnumPipePart.CENTER.getIndex()];
        double horizPos = 0.26;
        Vec3d offset = offsets[EnumPipePart.CENTER.getIndex()];
        if (offset == null) {
            offset = Vec3d.field_186680_a;
        }
        fluidBuffer.func_178969_c(x - offset.field_72450_a, y - offset.field_72448_b, z - offset.field_72449_c);
        if (horizontal | !vertical) {
            Vec3d min = new Vec3d(0.26, 0.26, 0.26);
            Vec3d max = new Vec3d(0.74, 0.74, 0.74);
            min = min.func_178787_e(offset);
            max = max.func_178787_e(offset);
            FluidRenderer.renderFluid(FluidSpriteType.FROZEN, forRender, amount, flow.capacity, min, max, fluidBuffer, sides);
            horizPos += (max.field_72448_b - min.field_72448_b) * amount / (double)flow.capacity;
        }
        if (vertical && horizPos < 0.74) {
            double perc = amount / (double)flow.capacity;
            perc = Math.sqrt(perc);
            double minXZ = 0.5 - 0.24 * perc;
            double maxXZ = 0.5 + 0.24 * perc;
            double yMin = gas ? 0.26 : horizPos;
            double yMax = gas ? 1.0 - horizPos : 0.74;
            Vec3d min = new Vec3d(minXZ, yMin, minXZ);
            Vec3d max = new Vec3d(maxXZ, yMax, maxXZ);
            min = min.func_178787_e(offset);
            max = max.func_178787_e(offset);
            FluidRenderer.renderFluid(FluidSpriteType.FROZEN, forRender, 1.0, 1.0, min, max, fluidBuffer, sides);
        }
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179089_o();
        prof.func_76318_c("draw");
        fluidBuffer.func_178969_c(0.0, 0.0, 0.0);
        Tessellator.func_178181_a().func_78381_a();
        RenderHelper.func_74519_b();
        FluidRenderer.vertex.lighti(15, 15);
        prof.func_76319_b();
    }

    private static void drawFluidCenter(FluidStack fluid, double percentage, boolean horizontal, boolean above, BufferBuilder bb) {
        boolean[] sides = new boolean[6];
        Arrays.fill(sides, true);
        Vec3d min = new Vec3d(0.26, 0.26, 0.26);
        Vec3d max = new Vec3d(0.74, 0.74, 0.74);
        FluidRenderer.renderFluid(FluidSpriteType.STILL, fluid, percentage, 1.0, min, max, bb, sides);
    }
}

