/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.render;

import buildcraft.api.transport.pipe.IPipeBehaviourRenderer;
import buildcraft.api.transport.pipe.IPipeFlowRenderer;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.api.transport.pluggable.IPlugDynamicRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.client.PipeRegistryClient;
import buildcraft.transport.client.render.PipeWireRenderer;
import buildcraft.transport.pipe.Pipe;
import buildcraft.transport.tile.TilePipeHolder;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.animation.FastTESR;

public class RenderPipeHolder
extends FastTESR<TilePipeHolder> {
    public void renderTileEntityFast(@Nonnull TilePipeHolder pipe, double x, double y, double z, float partialTicks, int destroyStage, float partial, @Nonnull BufferBuilder buffer) {
        this.func_147499_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("pipe");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("wire");
        PipeWireRenderer.renderWires(pipe, x, y, z, buffer);
        Minecraft.func_71410_x().field_71424_I.func_76318_c("pluggable");
        RenderPipeHolder.renderPluggables(pipe, x, y, z, partialTicks, buffer);
        Minecraft.func_71410_x().field_71424_I.func_76318_c("contents");
        RenderPipeHolder.renderContents(pipe, x, y, z, partialTicks, buffer);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private static void renderPluggables(TilePipeHolder pipe, double x, double y, double z, float partialTicks, BufferBuilder bb) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            PipePluggable plug = pipe.getPluggable(face);
            if (plug == null) continue;
            RenderPipeHolder.renderPlug(plug, x, y, z, partialTicks, bb);
        }
    }

    private static <P extends PipePluggable> void renderPlug(P plug, double x, double y, double z, float partialTicks, BufferBuilder bb) {
        IPlugDynamicRenderer<P> renderer = PipeRegistryClient.getPlugRenderer(plug);
        if (renderer != null) {
            Minecraft.func_71410_x().field_71424_I.startSection(plug.getClass());
            renderer.render(plug, x, y, z, partialTicks, bb);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    private static void renderContents(TilePipeHolder pipe, double x, double y, double z, float partialTicks, BufferBuilder bb) {
        Pipe p = pipe.getPipe();
        if (p == null) {
            return;
        }
        if (p.flow != null) {
            RenderPipeHolder.renderFlow(p.flow, x, y, z, partialTicks, bb);
        }
        if (p.behaviour != null) {
            RenderPipeHolder.renderBehaviour(p.behaviour, x, y, z, partialTicks, bb);
        }
    }

    private static <F extends PipeFlow> void renderFlow(F flow, double x, double y, double z, float partialTicks, BufferBuilder bb) {
        IPipeFlowRenderer<F> renderer = PipeRegistryClient.getFlowRenderer(flow);
        if (renderer != null) {
            Minecraft.func_71410_x().field_71424_I.startSection(flow.getClass());
            renderer.render(flow, x, y, z, partialTicks, bb);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    private static <B extends PipeBehaviour> void renderBehaviour(B behaviour, double x, double y, double z, float partialTicks, BufferBuilder bb) {
        IPipeBehaviourRenderer<B> renderer = PipeRegistryClient.getBehaviourRenderer(behaviour);
        if (renderer != null) {
            Minecraft.func_71410_x().field_71424_I.startSection(behaviour.getClass());
            renderer.render(behaviour, x, y, z, partialTicks, bb);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }
}

