/*
 * Decompiled with CFR 0.152.
 */
package lib.modelloader;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;

public class ModelHandle {
    static Map<String, IBakedModel> loadedModels = Maps.newHashMap();
    private final Map<String, String> textureReplacements = Maps.newHashMap();
    private final ResourceLocation model;
    private final String key;
    private final VertexFormat vertexFormat;
    private final IModelState state;
    private final boolean uvLock;
    private static int reloadCount = 0;
    private int cacheCount = 0;
    private IBakedModel cacheCopy;
    private static boolean initialized = false;

    private ModelHandle(ResourceLocation model) {
        this.model = model;
        this.vertexFormat = DefaultVertexFormats.field_176599_b;
        this.state = null;
        this.uvLock = false;
        this.key = this.computeKey();
    }

    private ModelHandle(ModelHandle handle, String texChannel, String resloc) {
        this.model = handle.model;
        this.vertexFormat = handle.vertexFormat;
        this.state = handle.state;
        this.uvLock = handle.uvLock;
        this.textureReplacements.putAll(handle.textureReplacements);
        this.textureReplacements.put(texChannel, resloc);
        this.key = this.computeKey();
    }

    private ModelHandle(ModelHandle handle, VertexFormat fmt) {
        this.model = handle.model;
        this.vertexFormat = fmt;
        this.state = handle.state;
        this.uvLock = handle.uvLock;
        this.textureReplacements.putAll(handle.textureReplacements);
        this.key = this.computeKey();
    }

    private ModelHandle(ModelHandle handle, IModelState state) {
        this.model = handle.model;
        this.vertexFormat = handle.vertexFormat;
        this.state = state;
        this.uvLock = handle.uvLock;
        this.textureReplacements.putAll(handle.textureReplacements);
        this.key = this.computeKey();
    }

    private ModelHandle(ModelHandle handle, boolean uvLock) {
        this.model = handle.model;
        this.vertexFormat = handle.vertexFormat;
        this.state = handle.state;
        this.uvLock = uvLock;
        this.textureReplacements.putAll(handle.textureReplacements);
        this.key = this.computeKey();
    }

    private String computeKey() {
        StringBuilder b = new StringBuilder();
        b.append(this.model.toString());
        for (Map.Entry<String, String> entry : this.textureReplacements.entrySet()) {
            b.append("//");
            b.append(entry.getKey());
            b.append("/");
            b.append(entry.getValue());
        }
        b.append("//VF:");
        b.append(this.vertexFormat.hashCode());
        b.append("//S:");
        b.append(this.state != null ? Integer.valueOf(this.state.hashCode()) : "n");
        b.append("//UVL:");
        b.append(this.uvLock);
        return b.toString();
    }

    public ModelHandle replace(String texChannel, String resloc) {
        if (this.textureReplacements.containsKey(texChannel) && this.textureReplacements.get(texChannel).equals(resloc)) {
            return this;
        }
        return new ModelHandle(this, texChannel, resloc);
    }

    public ModelHandle vertexFormat(VertexFormat fmt) {
        if (this.vertexFormat == fmt) {
            return this;
        }
        return new ModelHandle(this, fmt);
    }

    public ModelHandle state(IModelState newState) {
        if (this.state == newState) {
            return this;
        }
        return new ModelHandle(this, newState);
    }

    public ModelHandle uvLock(boolean uvLock) {
        if (this.uvLock == uvLock) {
            return this;
        }
        return new ModelHandle(this, uvLock);
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getTextureReplacements() {
        return this.textureReplacements;
    }

    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @Nullable
    public IModelState getState() {
        return this.state;
    }

    public boolean uvLocked() {
        return this.uvLock;
    }

    public IBakedModel get() {
        if (this.cacheCount == reloadCount && this.cacheCopy != null) {
            return this.cacheCopy;
        }
        this.cacheCopy = ModelHandle.loadModel(this);
        return this.cacheCopy;
    }

    public void render() {
        ModelHandle.renderModel(this.get(), this.getVertexFormat());
    }

    public void render(int color) {
        ModelHandle.renderModel(this.get(), this.getVertexFormat(), color);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        if (rm instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)rm).func_110542_a(__ -> {
                loadedModels.clear();
                ++reloadCount;
            });
        }
    }

    @Nonnull
    public static ModelHandle of(String model) {
        return new ModelHandle(new ResourceLocation(model));
    }

    @Nonnull
    public static ModelHandle of(ResourceLocation model) {
        return new ModelHandle(model);
    }

    private static void renderModel(IBakedModel model, VertexFormat fmt) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, fmt);
        for (BakedQuad bakedquad : model.func_188616_a(null, null, 0L)) {
            worldrenderer.func_178981_a(bakedquad.func_178209_a());
        }
        tessellator.func_78381_a();
    }

    private static void renderModel(IBakedModel model, VertexFormat fmt, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, fmt);
        for (BakedQuad bakedquad : model.func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((BufferBuilder)worldrenderer, (BakedQuad)bakedquad, (int)color);
        }
        tessellator.func_78381_a();
    }

    private static IBakedModel loadModel(ModelHandle handle) {
        IBakedModel model = loadedModels.get(handle.getKey());
        if (model != null) {
            return model;
        }
        try {
            IModelState state;
            IModel mod = ModelLoaderRegistry.getModel((ResourceLocation)handle.getModel());
            if (handle.getTextureReplacements().size() > 0) {
                mod = mod.retexture(ImmutableMap.copyOf(handle.getTextureReplacements()));
            }
            if (handle.uvLocked()) {
                mod = mod.uvlock(true);
            }
            if ((state = handle.getState()) == null) {
                state = mod.getDefaultState();
            }
            model = mod.bake(state, handle.getVertexFormat(), ModelLoader.defaultTextureGetter());
            loadedModels.put(handle.getKey(), model);
            return model;
        }
        catch (Exception e) {
            throw new ReportedException(new CrashReport("Error loading custom model " + handle.getModel(), (Throwable)e));
        }
    }
}

