/*
 * Decompiled with CFR 0.152.
 */
package lib.playerclass;

import lib.item.armor.ModeledArmor;
import lib.playerclass.capability.CapabilityPlayerClassProvider;
import lib.playerclass.capability.PlayerClass;
import lib.playerclass.network.CPacketSyncPlayerClass;
import lib.playerclass.network.NetworkHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DeterminePlayerClass {
    private static final int BOOTS = 36;
    private static final int LEGS = 37;
    private static final int CHEST = 38;
    private static final int HELM = 39;

    public DeterminePlayerClass() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAttach(AttachCapabilitiesEvent event) {
        Object object = event.getObject();
        if (object instanceof EntityPlayer) {
            event.addCapability(CapabilityPlayerClassProvider.KEY, (ICapabilityProvider)new CapabilityPlayerClassProvider((EntityPlayer)object));
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            this.determinePlayerClass(player);
        }
    }

    private void determinePlayerClass(EntityPlayer player) {
        String classname = "noClass";
        String shieldName = "_noShield";
        ItemStack offhand = player.func_184592_cb();
        PlayerClass playerclass = PlayerClass.get(player);
        if (!offhand.func_190926_b()) {
            if (offhand.func_77973_b() instanceof ItemShield) {
                shieldName = playerclass.vanillaShieldSuffix();
                playerclass.setPlayerClass(classname + shieldName);
            }
        } else {
            playerclass.setPlayerClass(classname + shieldName);
        }
        for (ItemStack is : player.field_71071_by.field_70460_b) {
            if (is == null) {
                playerclass.setPlayerClass(classname + shieldName);
                this.sync(player, classname, shieldName);
                return;
            }
            if (is.func_77973_b() instanceof ModeledArmor) continue;
            playerclass.setPlayerClass(classname + shieldName);
            this.sync(player, classname, shieldName);
            return;
        }
        String a = ((ModeledArmor)player.field_71071_by.func_70301_a(39).func_77973_b()).armorClassName();
        String b = ((ModeledArmor)player.field_71071_by.func_70301_a(38).func_77973_b()).armorClassName();
        String c = ((ModeledArmor)player.field_71071_by.func_70301_a(37).func_77973_b()).armorClassName();
        String d = ((ModeledArmor)player.field_71071_by.func_70301_a(36).func_77973_b()).armorClassName();
        if (!(a.equals(b) && a.equals(c) && a.equals(d))) {
            playerclass.setPlayerClass(classname + shieldName);
            this.sync(player, classname, shieldName);
            return;
        }
        classname = a;
        ModeledArmor helm = (ModeledArmor)player.field_71071_by.func_70301_a(39).func_77973_b();
        if (!offhand.func_190926_b() && shieldName.equals("_noShield") && helm.getLinkedShieldItem() != Items.field_190931_a && offhand.func_77973_b() == helm.getLinkedShieldItem()) {
            shieldName = PlayerClass.get(player).classShieldSuffix();
        }
        if (!playerclass.getPlayerClass().equals(classname + shieldName)) {
            playerclass.setPlayerClass(classname + shieldName);
        }
        this.sync(player, classname, shieldName);
    }

    private void sync(EntityPlayer player, String classname, String shieldName) {
        if (player instanceof EntityPlayerMP) {
            NetworkHandler.NETWORK.sendTo((IMessage)new CPacketSyncPlayerClass(classname + shieldName), (EntityPlayerMP)player);
        }
    }
}

