/*
 * Decompiled with CFR 0.152.
 */
package lib.recipes;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PotRecipes {
    private static final PotRecipes INSTANCE = new PotRecipes();
    private Map<RecipeEntry, RecipeEntry> recipes = new HashMap<RecipeEntry, RecipeEntry>();

    public static PotRecipes getInstance() {
        return INSTANCE;
    }

    public void addRecipe(ItemStack entry, ItemStack output) {
        RecipeEntry reEntry = new RecipeEntry(entry);
        RecipeEntry reOutput = new RecipeEntry(output);
        this.recipes.put(reEntry, reOutput);
    }

    public ItemStack getCookingResult(ItemStack stack) {
        RecipeEntry entry = new RecipeEntry(stack);
        for (Map.Entry<RecipeEntry, RecipeEntry> entry_lookup : this.recipes.entrySet()) {
            RecipeEntry key = entry_lookup.getKey();
            if (!this.areEntriesEqual(entry, key)) continue;
            return entry_lookup.getValue().getStack().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private boolean areEntriesEqual(RecipeEntry a, RecipeEntry b) {
        return a.meta == b.meta && a.item == b.item;
    }

    private class RecipeEntry {
        int amount;
        Item item;
        int meta;

        public RecipeEntry(ItemStack stack) {
            this.amount = stack.func_190916_E();
            this.item = stack.func_77973_b();
            this.meta = stack.func_77960_j();
        }

        public ItemStack getStack() {
            return new ItemStack(this.item, this.amount, this.meta);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RecipeEntry)) {
                return false;
            }
            return PotRecipes.this.areEntriesEqual((RecipeEntry)obj, this);
        }
    }
}

