/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;

public final class BinaryRelations {
    public static final double DEFAULT_COMPARISON_EPSILON = 1.0E-14;
    static double epsilon = 1.0E-14;
    static boolean epsilonComparison = true;

    public static final void setExactComparison() {
        epsilonComparison = false;
    }

    public static final void setEpsilonComparison() {
        epsilonComparison = true;
    }

    public static final void setEpsilon(double epsilon) {
        if (epsilon > 0.0) {
            BinaryRelations.epsilon = epsilon;
        }
    }

    public static final void setDefaultEpsilon() {
        epsilon = 1.0E-14;
    }

    public static final double getEpsilon() {
        return epsilon;
    }

    public static final boolean checkIfEpsilonMode() {
        return epsilonComparison;
    }

    public static final boolean checkIfExactMode() {
        return !epsilonComparison;
    }

    public static final double eq(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        double result = 0.0;
        if (epsilonComparison) {
            if (MathFunctions.abs(a - b) <= eps) {
                result = 1.0;
            }
        } else if (a == b) {
            result = 1.0;
        }
        return result;
    }

    public static final double neq(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        double result = 0.0;
        if (epsilonComparison) {
            if (MathFunctions.abs(a - b) > eps) {
                result = 1.0;
            }
        } else if (a != b) {
            result = 1.0;
        }
        return result;
    }

    public static final double lt(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        double result = 0.0;
        if (epsilonComparison) {
            if (a < b - eps) {
                result = 1.0;
            }
        } else if (a < b) {
            result = 1.0;
        }
        return result;
    }

    public static final double gt(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        double result = 0.0;
        if (epsilonComparison) {
            if (a > b + eps) {
                result = 1.0;
            }
        } else if (a > b) {
            result = 1.0;
        }
        return result;
    }

    public static final double leq(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        double result = 0.0;
        if (epsilonComparison) {
            if (a <= b + eps) {
                result = 1.0;
            }
        } else if (a <= b) {
            result = 1.0;
        }
        return result;
    }

    public static final double geq(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        double eps = NumberTheory.max(epsilon, MathFunctions.ulp(b));
        double result = 0.0;
        if (epsilonComparison) {
            if (a >= b - eps) {
                result = 1.0;
            }
        } else if (a >= b) {
            result = 1.0;
        }
        return result;
    }
}

