/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAirLockFrame
extends BlockAdvancedTile
implements IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumAirLockType> AIR_LOCK_TYPE = PropertyEnum.func_177709_a((String)"airlocktype", EnumAirLockType.class);

    public BlockAirLockFrame(String assetName) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AIR_LOCK_TYPE, (Comparable)((Object)EnumAirLockType.AIR_LOCK_FRAME)));
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, EnumAirLockType.AIR_LOCK_FRAME.getMeta()));
        list.add((Object)new ItemStack((Block)this, 1, EnumAirLockType.AIR_LOCK_CONTROLLER.getMeta()));
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityAirLockController && placer instanceof EntityPlayer) {
            ((TileEntityAirLockController)tile).ownerName = PlayerUtil.getName((EntityPlayer)placer);
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (((EnumAirLockType)((Object)state.func_177229_b(AIR_LOCK_TYPE))).getMeta() == EnumAirLockType.AIR_LOCK_FRAME.getMeta()) {
            return new TileEntityAirLock();
        }
        return new TileEntityAirLockController();
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (((EnumAirLockType)((Object)state.func_177229_b(AIR_LOCK_TYPE))).getMeta() == EnumAirLockType.AIR_LOCK_CONTROLLER.getMeta() && tile instanceof TileEntityAirLockController) {
            entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityAirLockController) {
            ((TileEntityAirLockController)tile).unsealAirLock();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AIR_LOCK_TYPE, (Comparable)((Object)EnumAirLockType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumAirLockType)((Object)state.func_177229_b(AIR_LOCK_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AIR_LOCK_TYPE});
    }

    @Override
    public String getShiftDescription(int itemDamage) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int itemDamage) {
        return true;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    private static enum EnumAirLockType implements IStringSerializable
    {
        AIR_LOCK_FRAME(0, "air_lock_frame"),
        AIR_LOCK_CONTROLLER(1, "air_lock_controller");

        private final int meta;
        private final String name;

        private EnumAirLockType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumAirLockType byMetadata(int meta) {
            return EnumAirLockType.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

