/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardTime
extends ItemCardBase {
    public ItemCardTime() {
        super(19, "card_time");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        reader.setInt("time", (int)((world.func_72820_D() + 6000L) % 24000L));
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        int time = reader.getInt("time");
        int hours = time / 1000;
        int minutes = time % 1000 * 6 / 100;
        String suffix = "";
        if ((settings & 1) == 0) {
            String string = suffix = hours < 12 ? "AM" : "PM";
            if ((hours %= 12) == 0) {
                hours += 12;
            }
        }
        result.add(new PanelString("msg.ec.InfoPanelTime", String.format("%02d:%02d%s", hours, minutes, suffix), showLabels));
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(1);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cb24h", (Object[])new Object[0]), 1));
        return result;
    }

    @Override
    public boolean isRemoteCard() {
        return false;
    }
}

