/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car;

import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.car.registries.CarFluid;
import de.maxhenkel.car.registries.CarProperties;
import de.maxhenkel.car.registries.FuelStationFluid;
import de.maxhenkel.car.registries.GeneratorRecipe;
import de.maxhenkel.tools.FluidSelector;
import de.maxhenkel.tools.json.JSONArray;
import de.maxhenkel.tools.json.JSONException;
import de.maxhenkel.tools.json.JSONObject;
import de.maxhenkel.tools.json.JsonConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.IOUtils;

public class Config {
    public static File configFolder;
    public static Configuration config;
    public static int backmixReactorEnergyStorage;
    public static int backmixReactorEnergyUsage;
    public static int backmixReactorFluidStorage;
    public static int backmixReactorGeneratingTime;
    public static int backmixReactorMixGeneration;
    public static int backmixReactorMethanolUsage;
    public static int backmixReactorCanolaUsage;
    public static int blastFurnaceEnergyStorage;
    public static int blastFurnaceGeneratingTime;
    public static int blastFurnaceFluidStorage;
    public static int blastFurnaceEnergyUsage;
    public static int blastFurnaceFluidGeneration;
    public static int oilMillEnergyStorage;
    public static int oilMillGeneratingTime;
    public static int oilMillFluidStorage;
    public static int oilMillEnergyUsage;
    public static int oilMillFluidGeneration;
    public static int cableTransferRate;
    public static int dynamoEnergyStorage;
    public static int dynamoEnergyGeneration;
    public static int fluidExtractorDrainSpeed;
    public static int fuelStationTransferRate;
    public static int generatorEnergyStorage;
    public static int generatorFluidStorage;
    public static int splitTankFluidStorage;
    public static int splitTankGeneratingTime;
    public static int splitTankMixUsage;
    public static int splitTankGlycerinGeneration;
    public static int splitTankBioDieselGeneration;
    public static float repairKitRepairAmount;
    public static int canisterMaxFuel;
    public static float carVolume;
    public static boolean thirdPersonEnter;
    public static boolean carGroundSpeed;
    public static Block[] carDriveBlocks;
    private static String[] carDriveBlocksStr;
    public static float carStepHeight;
    public static boolean collideWithEntities;
    public static boolean damageEntities;
    public static boolean hornFlee;
    public static boolean useBattery;
    public static boolean dynamicLights;
    public static boolean tempInFarenheit;
    public static boolean tarRecipe;
    public static boolean painterRecipe;
    public static boolean tankRecipe;
    public static boolean carPartsRecipe;
    public static boolean crashBarrierRecipe;
    public static boolean backmixReactorRecipe;
    public static boolean blastFurnaceRecipe;
    public static boolean oilMillRecipe;
    public static boolean cableRecipe;
    public static boolean dynamoRecipe;
    public static boolean fluidExtractorRecipe;
    public static boolean fluidPipeRecipe;
    public static boolean fuelStationRecipe;
    public static boolean generatorRecipe;
    public static boolean splitTankRecipe;
    public static boolean repairKitRecipe;
    public static boolean batteryRecipe;
    public static boolean canisterRecipe;
    public static boolean carWorkshopRecipe;
    public static boolean keyRecipe;
    public static boolean signRecipe;
    public static boolean numberPlateRecipe;
    public static boolean canolaSeedDrop;
    public static boolean teleportDimension;
    public static int teleportDimID;

    public static void init(File configFolder) {
        Config.configFolder = configFolder;
        config = new Configuration(new File(configFolder, "main.cfg"));
        Config.initMain();
    }

    public static void postInit() {
        if (configFolder == null) {
            return;
        }
        Config.initGenerator();
        Config.initFuelStation();
        Config.initCar();
        try {
            Config.initDimension();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Config.postInitMain();
    }

    private static void initDimension() throws JSONException, IOException {
        File dimension = new File(configFolder, "teleport.json");
        if (!dimension.exists()) {
            return;
        }
        FileInputStream inputStream = new FileInputStream(dimension);
        JSONObject jsonObject = new JSONObject(IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset()));
        if (jsonObject.has("dimID")) {
            int dimid = jsonObject.getInt("dimID");
            teleportDimension = true;
            teleportDimID = dimid;
        }
    }

    private static void initGenerator() {
        JsonConfig cfg = new JsonConfig(new File(configFolder, "generator.json"));
        JSONArray arr = new JSONArray();
        arr.put(new JSONObject().put("fluid", new FluidSelector(ModFluids.BIO_DIESEL).toString()).put("energy", 500));
        JSONArray fluids = cfg.getJsonArray("generator_fluids", arr);
        for (int i = 0; i < fluids.length(); ++i) {
            JSONObject obj = fluids.getJSONObject(i);
            if (obj == null) continue;
            FluidSelector sel = FluidSelector.fromString(obj.getString("fluid"));
            int amount = obj.getInt("energy");
            if (sel == null || amount <= 0) continue;
            GeneratorRecipe.REGISTRY.register(sel.toString(), new GeneratorRecipe(sel, amount));
        }
    }

    private static void initCar() {
        JsonConfig cfg = new JsonConfig(new File(configFolder, "car.json"));
        JSONArray arr = new JSONArray();
        arr.put(new JSONObject().put("id", "car_wood").put("fluids", new JSONArray().put(new JSONObject().put("fluid", new FluidSelector(ModFluids.BIO_DIESEL).toString()).put("efficiency", 0.3))).put("speed", 0.5).put("reverseSpeed", 0.2).put("acceleration", 0.032));
        arr.put(new JSONObject().put("id", "car_big_wood").put("fluids", new JSONArray().put(new JSONObject().put("fluid", new FluidSelector(ModFluids.BIO_DIESEL).toString()).put("efficiency", 0.2))).put("speed", 0.48).put("reverseSpeed", 0.2).put("acceleration", 0.032));
        arr.put(new JSONObject().put("id", "car_transporter").put("fluids", new JSONArray().put(new JSONObject().put("fluid", new FluidSelector(ModFluids.BIO_DIESEL).toString()).put("efficiency", 0.3))).put("speed", 0.4).put("reverseSpeed", 0.2).put("acceleration", 0.032));
        arr.put(new JSONObject().put("id", "car_sport").put("fluids", new JSONArray().put(new JSONObject().put("fluid", new FluidSelector(ModFluids.BIO_DIESEL).toString()).put("efficiency", 0.12))).put("speed", 0.65).put("reverseSpeed", 0.2).put("acceleration", 0.04));
        JSONArray cars = cfg.getJsonArray("cars", arr);
        for (int i = 0; i < cars.length(); ++i) {
            String carID;
            JSONObject car = cars.getJSONObject(i);
            if (car == null || (carID = car.getString("id")) == null) continue;
            JSONArray fluids = car.getJSONArray("fluids");
            Config.handleFluids(fluids, carID);
            Config.handleProperties(car, carID);
        }
    }

    private static void handleFluids(JSONArray fluids, String carID) {
        if (fluids == null) {
            return;
        }
        for (int j = 0; j < fluids.length(); ++j) {
            JSONObject jo = fluids.getJSONObject(j);
            if (jo == null) continue;
            FluidSelector sel = FluidSelector.fromString(jo.getString("fluid"));
            double efficiency = jo.getDouble("efficiency");
            if (sel == null || efficiency <= 0.0) continue;
            CarFluid.REGISTRY.register(carID + "_" + sel.getFluid().getName(), new CarFluid(carID, sel, efficiency));
        }
    }

    private static void handleProperties(JSONObject car, String carID) {
        float speed = (float)car.getDouble("speed");
        float reverseSpeed = (float)car.getDouble("reverseSpeed");
        float acceleration = (float)car.getDouble("acceleration");
        speed = Math.max(speed, 0.001f);
        speed = Math.min(speed, 10.0f);
        reverseSpeed = Math.max(reverseSpeed, 0.001f);
        reverseSpeed = Math.min(reverseSpeed, 10.0f);
        acceleration = Math.max(acceleration, 1.0E-4f);
        acceleration = Math.min(acceleration, 10.0f);
        CarProperties.REGISTRY.register(carID, new CarProperties(carID, speed, acceleration, reverseSpeed));
    }

    private static void initFuelStation() {
        JsonConfig cfg = new JsonConfig(new File(configFolder, "fuel_station.json"));
        JSONArray arr = new JSONArray();
        arr.put(ModFluids.BIO_DIESEL.getName());
        JSONArray fluids = cfg.getJsonArray("valid_fluids", arr);
        for (int i = 0; i < fluids.length(); ++i) {
            FluidSelector sel;
            String str = fluids.getString(i);
            if (str == null || (sel = FluidSelector.fromString(str)) == null) continue;
            FuelStationFluid.REGISTRY.register(sel.toString(), new FuelStationFluid(sel));
        }
    }

    private static void initMain() {
        backmixReactorEnergyStorage = config.getInt("backmix_reactor_energy_storage", "machines.backmix_reactor", 10000, 100, Short.MAX_VALUE, "");
        backmixReactorEnergyUsage = config.getInt("backmix_reactor_energy_usage", "machines.backmix_reactor", 10, 1, Short.MAX_VALUE, "");
        backmixReactorFluidStorage = config.getInt("backmix_reactor_fluid_storage", "machines.backmix_reactor", 3000, 1000, Short.MAX_VALUE, "");
        backmixReactorGeneratingTime = config.getInt("backmix_reactor_generating_time", "machines.backmix_reactor", 200, 10, Short.MAX_VALUE, "");
        backmixReactorMixGeneration = config.getInt("backmix_reactor_mix_generation", "machines.backmix_reactor", 100, 1, Short.MAX_VALUE, "");
        backmixReactorMethanolUsage = config.getInt("backmix_reactor_methanol_usage", "machines.backmix_reactor", 50, 1, Short.MAX_VALUE, "");
        backmixReactorCanolaUsage = config.getInt("backmix_reactor_canola_usage", "machines.backmix_reactor", 50, 1, Short.MAX_VALUE, "");
        blastFurnaceEnergyStorage = config.getInt("blast_furnace_energy_storage", "machines.blast_furnace", 10000, 1000, Short.MAX_VALUE, "");
        blastFurnaceGeneratingTime = config.getInt("blast_furnace_generating_time", "machines.blast_furnace", 200, 10, Short.MAX_VALUE, "");
        blastFurnaceFluidStorage = config.getInt("blast_furnace_fluid_storage", "machines.blast_furnace", 3000, 1000, Short.MAX_VALUE, "");
        blastFurnaceEnergyUsage = config.getInt("blast_furnace_energy_usage", "machines.blast_furnace", 10, 1, Short.MAX_VALUE, "");
        blastFurnaceFluidGeneration = config.getInt("blast_furnace_fluid_generation", "machines.blast_furnace", 100, 1, Short.MAX_VALUE, "");
        oilMillEnergyStorage = config.getInt("oil_mill_energy_storage", "machines.oil_mill", 10000, 1000, Short.MAX_VALUE, "");
        oilMillGeneratingTime = config.getInt("oil_mill_generating_time", "machines.oil_mill", 200, 10, Short.MAX_VALUE, "");
        oilMillFluidStorage = config.getInt("oil_mill_fluid_storage", "machines.oil_mill", 3000, 1000, Short.MAX_VALUE, "");
        oilMillEnergyUsage = config.getInt("oil_mill_energy_usage", "machines.oil_mill", 10, 1, Short.MAX_VALUE, "");
        oilMillFluidGeneration = config.getInt("oil_mill_fluid_generation", "machines.oil_mill", 100, 1, Short.MAX_VALUE, "");
        cableTransferRate = config.getInt("cable_transfer_rate", "machines.cable", 256, 64, Short.MAX_VALUE, "");
        dynamoRecipe = config.getBoolean("dynamo_recipe", "machines.dynamo", true, "");
        dynamoEnergyStorage = config.getInt("dynamo_energy_storage", "machines.dynamo", 1000, 100, Short.MAX_VALUE, "");
        dynamoEnergyGeneration = config.getInt("dynamo_energy_generation", "machines.dynamo", 25, 1, Short.MAX_VALUE, "");
        fluidExtractorDrainSpeed = config.getInt("fluid_extractor_drain_speed", "machines.fluid_extractor", 25, 5, Short.MAX_VALUE, "");
        fuelStationTransferRate = config.getInt("fuel_station_transfer_rate", "machines.fuel_station", 5, 1, Short.MAX_VALUE, "");
        generatorEnergyStorage = config.getInt("generator_energy_storage", "machines.generator", 30000, 1000, Short.MAX_VALUE, "");
        generatorFluidStorage = config.getInt("generator_fluid_storage", "machines.generator", 3000, 1000, Short.MAX_VALUE, "");
        splitTankFluidStorage = config.getInt("split_tank_fluid_storage", "machines.split_tank", 3000, 1000, Short.MAX_VALUE, "");
        splitTankGeneratingTime = config.getInt("split_tank_generating_time", "machines.split_tank", 800, 10, Short.MAX_VALUE, "");
        splitTankMixUsage = config.getInt("split_tank_mix_usage", "machines.split_tank", 100, 1, Short.MAX_VALUE, "");
        splitTankGlycerinGeneration = config.getInt("split_tank_glycerin_generation", "machines.split_tank", 10, 1, Short.MAX_VALUE, "");
        splitTankBioDieselGeneration = config.getInt("split_tank_bio_diesel_generation", "machines.split_tank", 100, 1, Short.MAX_VALUE, "");
        repairKitRepairAmount = config.getFloat("repair_kit_repair_amount", "items.repair_kit", 5.0f, 0.1f, 100.0f, "");
        canisterMaxFuel = config.getInt("canister_max_fuel", "items.canister", 100, 1, 1000, "");
        carVolume = config.getFloat("car_volume", "car", 0.1f, 0.0f, 1.0f, "");
        thirdPersonEnter = config.getBoolean("third_person_when_enter_car", "car", true, "");
        carStepHeight = config.getFloat("car_step_height", "car", 0.6f, 0.1f, 128.0f, "The height a car can drive up");
        collideWithEntities = config.getBoolean("collide_with_entities", "car", false, "Whether the cars should collide with other entities (except cars)");
        damageEntities = config.getBoolean("damage_entities", "car", true, "Whether the cars should damage other entities on collision");
        hornFlee = config.getBoolean("horn_flee", "car", true, "Whether animals flee from the car when the horn is activted");
        useBattery = config.getBoolean("use_battery", "car", true, "True if starting the car should use battery");
        dynamicLights = config.getBoolean("dynamic_lights", "car", true, "Whether cars should emit light when the DynamicLights mod is installed");
        tempInFarenheit = config.getBoolean("temp_farenheit", "car", false, "True if the car temperature should be displayed in farenheit");
        carGroundSpeed = config.getBoolean("road_blocks_enabled", "car", false, "Whether the cars drive slower on non road blocks");
        String[] def = new String[]{"car:tar", "car:tar_slab", "car:tar_slope_flat_upper", "car:tar_slope_flat_lower", "car:tar_slope"};
        String[] blocks = config.getStringList("road_blocks", "car", def, "A list of blocks the car can drive faster on (only if 'road_blocks_enabled' is set to true)");
        if (blocks == null) {
            blocks = def;
        }
        carDriveBlocksStr = blocks;
        tarRecipe = config.getBoolean("tar_recipe", "recipes", true, "");
        painterRecipe = config.getBoolean("painter_recipe", "recipes", true, "");
        tankRecipe = config.getBoolean("painter_recipe", "recipes", true, "");
        carPartsRecipe = config.getBoolean("car_parts_recipe", "recipes", true, "");
        crashBarrierRecipe = config.getBoolean("crash_barrier_recipe", "recipes", true, "");
        backmixReactorRecipe = config.getBoolean("backmix_reactor_recipe", "recipes", true, "");
        blastFurnaceRecipe = config.getBoolean("blast_furnace_recipe", "recipes", true, "");
        oilMillRecipe = config.getBoolean("oil_mill_recipe", "recipes", true, "");
        cableRecipe = config.getBoolean("cable_recipe", "recipes", true, "");
        dynamoRecipe = config.getBoolean("dynamo_recipe", "recipes", true, "");
        fluidExtractorRecipe = config.getBoolean("fluid_extractor_recipe", "recipes", true, "");
        fluidPipeRecipe = config.getBoolean("fluid_pipe_recipe", "recipes", true, "");
        fuelStationRecipe = config.getBoolean("fuel_station_recipe", "recipes", true, "");
        generatorRecipe = config.getBoolean("generator_recipe", "recipes", true, "");
        splitTankRecipe = config.getBoolean("split_tank_recipe", "recipes", true, "");
        repairKitRecipe = config.getBoolean("repair_kit_recipe", "recipes", true, "");
        batteryRecipe = config.getBoolean("battery_recipe", "recipes", true, "");
        canisterRecipe = config.getBoolean("canister_recipe", "recipes", true, "");
        carWorkshopRecipe = config.getBoolean("car_workshop_recipe", "recipes", true, "");
        keyRecipe = config.getBoolean("key_clone_recipe", "recipes", true, "");
        signRecipe = config.getBoolean("sign_recipe", "recipes", true, "");
        numberPlateRecipe = config.getBoolean("number_plate_recipe", "recipes", true, "");
        canolaSeedDrop = config.getBoolean("canola_seed_drop", "drops", true, "");
        config.save();
    }

    public static void postInitMain() {
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (String s : carDriveBlocksStr) {
            Block b = Config.getBlock(s);
            if (b == null) continue;
            blockList.add(b);
        }
        carDriveBlocks = blockList.toArray(new Block[0]);
    }

    public static Block getBlock(String name) {
        try {
            String[] split = name.split(":");
            if (split.length == 2) {
                Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
                if (b.equals(Blocks.field_150350_a)) {
                    return null;
                }
                return b;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isDrivable(Block block) {
        for (Block b : carDriveBlocks) {
            if (!b.equals(block)) continue;
            return true;
        }
        return false;
    }

    static {
        backmixReactorEnergyStorage = 10000;
        backmixReactorEnergyUsage = 10;
        backmixReactorFluidStorage = 3000;
        backmixReactorGeneratingTime = 200;
        backmixReactorMixGeneration = 100;
        backmixReactorMethanolUsage = 50;
        backmixReactorCanolaUsage = 50;
        blastFurnaceEnergyStorage = 10000;
        blastFurnaceGeneratingTime = 200;
        blastFurnaceFluidStorage = 3000;
        blastFurnaceEnergyUsage = 10;
        blastFurnaceFluidGeneration = 100;
        oilMillEnergyStorage = 10000;
        oilMillGeneratingTime = 200;
        oilMillFluidStorage = 3000;
        oilMillEnergyUsage = 10;
        oilMillFluidGeneration = 100;
        cableTransferRate = 256;
        dynamoEnergyStorage = 1000;
        dynamoEnergyGeneration = 25;
        fluidExtractorDrainSpeed = 25;
        fuelStationTransferRate = 5;
        generatorEnergyStorage = 30000;
        generatorFluidStorage = 3000;
        splitTankFluidStorage = 3000;
        splitTankGeneratingTime = 800;
        splitTankMixUsage = 100;
        splitTankGlycerinGeneration = 10;
        splitTankBioDieselGeneration = 100;
        repairKitRepairAmount = 5.0f;
        canisterMaxFuel = 100;
        carVolume = 0.1f;
        thirdPersonEnter = true;
        carGroundSpeed = false;
        carDriveBlocks = new Block[0];
        carDriveBlocksStr = new String[0];
        collideWithEntities = false;
        damageEntities = true;
        hornFlee = true;
        useBattery = true;
        dynamicLights = true;
        tempInFarenheit = false;
        tarRecipe = true;
        painterRecipe = true;
        tankRecipe = true;
        carPartsRecipe = true;
        crashBarrierRecipe = true;
        backmixReactorRecipe = true;
        blastFurnaceRecipe = true;
        oilMillRecipe = true;
        cableRecipe = true;
        dynamoRecipe = true;
        fluidExtractorRecipe = true;
        fluidPipeRecipe = true;
        fuelStationRecipe = true;
        generatorRecipe = true;
        splitTankRecipe = true;
        repairKitRecipe = true;
        batteryRecipe = true;
        canisterRecipe = true;
        carWorkshopRecipe = true;
        keyRecipe = true;
        signRecipe = true;
        canolaSeedDrop = true;
        teleportDimension = false;
        teleportDimID = 0;
    }
}

