/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarFuelBase;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import de.maxhenkel.tools.MathTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderEvents {
    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent evt) {
        if (!evt.getType().equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        Entity e = player.func_184187_bx();
        if (e == null) {
            return;
        }
        if (!(e instanceof EntityCarFuelBase)) {
            return;
        }
        EntityCarFuelBase car = (EntityCarFuelBase)e;
        if (player.equals((Object)car.getDriver())) {
            evt.setCanceled(true);
            this.renderFuelBar((float)car.getFuelAmount() / (float)car.getMaxFuel());
            this.renderSpeed(car.getKilometerPerHour());
        }
    }

    public void renderFuelBar(float percent) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int x = scaledresolution.func_78326_a() / 2 - 91;
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        int k = scaledresolution.func_78328_b() - 32 + 3;
        mc.field_71456_v.func_73729_b(x, k, 0, 64, 182, 5);
        int j = (int)(percent * 182.0f);
        if (j > 0) {
            mc.field_71456_v.func_73729_b(x, k, 0, 69, j, 5);
        }
    }

    public void renderSpeed(float speed) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        String s = String.valueOf(MathTools.round(Math.abs(speed), 2));
        int i1 = (scaledresolution.func_78326_a() - mc.field_71456_v.func_175179_f().func_78256_a(s)) / 2;
        int j1 = scaledresolution.func_78328_b() - 31 - 4;
        mc.field_71456_v.func_175179_f().func_78276_b(s, i1 + 1, j1, 0);
        mc.field_71456_v.func_175179_f().func_78276_b(s, i1 - 1, j1, 0);
        mc.field_71456_v.func_175179_f().func_78276_b(s, i1, j1 + 1, 0);
        mc.field_71456_v.func_175179_f().func_78276_b(s, i1, j1 - 1, 0);
        mc.field_71456_v.func_175179_f().func_78276_b(s, i1, j1, 8453920);
    }

    @SubscribeEvent
    public void renderToolTip(RenderTooltipEvent.Pre event) {
        ItemStack stack = event.getStack();
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b("trading_item") && !compound.func_74767_n("trading_item")) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        if (event.getEntityPlayer().func_184187_bx() instanceof EntityCarBase) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            GlStateManager.func_179152_a((float)EntityVehicleBase.SCALE_FACTOR, (float)EntityVehicleBase.SCALE_FACTOR, (float)EntityVehicleBase.SCALE_FACTOR);
            GlStateManager.func_179109_b((float)0.0f, (float)((event.getEntityPlayer().field_70131_O - event.getEntityPlayer().field_70131_O * EntityVehicleBase.SCALE_FACTOR) / 1.5f), (float)0.0f);
            GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        if (event.getEntityPlayer().func_184187_bx() instanceof EntityCarBase) {
            GlStateManager.func_179121_F();
        }
    }
}

