/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import quphoria.compactvoidminers.blocks.TileEntityMachine;

public abstract class GuiMachine
extends GuiContainer {
    protected InventoryPlayer playerInv;
    protected ResourceLocation BG_TEXTURE;
    private TileEntityMachine tile;
    protected Rectangle energyBar = new Rectangle(0, 0, 0, 0);
    protected Rectangle progressBar = new Rectangle(0, 0, 0, 0);
    protected int energyBarTextureX = 0;
    protected int energyBarTextureY = 0;
    protected int progressBarTextureX = 0;
    protected int progressBarTextureY = 0;

    public GuiMachine(Container container, InventoryPlayer playerInv, TileEntityMachine tileEntityVoidPump) {
        super(container);
        this.tile = tileEntityVoidPump;
        this.playerInv = playerInv;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.BG_TEXTURE);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile != null) {
            int energy_level = (int)Math.round((double)this.energyBar.width * this.tile.getEnergyFraction());
            this.func_73729_b(x + this.energyBar.x, y + this.energyBar.y, this.energyBarTextureX, this.energyBarTextureY, energy_level, this.energyBar.height);
            int progress_level = (int)Math.round((double)this.progressBar.width * this.tile.getProgressFraction());
            this.func_73729_b(x + this.progressBar.x, y + this.progressBar.y, this.progressBarTextureX, this.progressBarTextureY, progress_level, this.progressBar.height);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>();
        this.drawTooltips(tooltip, mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
        if (!tooltip.isEmpty()) {
            this.func_146283_a(tooltip, mouseX, mouseY);
        }
    }

    protected String addDigitGrouping(int number) {
        String output = Integer.toString(number);
        for (int i = output.length() - 3; i > 0; i -= 3) {
            output = output.substring(0, i) + "," + output.substring(i);
        }
        return output;
    }

    protected void drawTooltips(List<String> tooltip, int mouseX, int mouseY) {
        if (this.tile != null) {
            if (this.energyBar.contains(mouseX, mouseY)) {
                tooltip.add("Energy: " + this.addDigitGrouping(this.tile.getEnergy()) + " RF");
                tooltip.add("Max: " + this.addDigitGrouping(this.tile.getMaxEnergy()) + " RF");
            }
            if (this.progressBar.contains(mouseX, mouseY)) {
                tooltip.add("Progress: " + (int)Math.round(100.0 * this.tile.getProgressFraction()) + "%");
            }
        }
    }
}

