/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import quphoria.compactvoidminers.CompactVoidMiners;
import quphoria.compactvoidminers.chunkloader.ChunkLoaderManager;
import quphoria.compactvoidminers.energy.MachineEnergyStorage;

public abstract class TileEntityMachine
extends TileEntity
implements ITickable {
    protected boolean shouldUpdate = true;
    protected ItemStackHandler upgradeInventory = new ItemStackHandler(4);
    protected MachineEnergyStorage energyStorage = new MachineEnergyStorage(10240, 131072, 0);
    protected Random rand;
    protected int lastEnergy = 0;
    protected int lastUpgradeInventory = 0;
    protected int maxEnergyUsage = 1024;
    protected int maxWaitTime = 126;
    protected int energyUsage = this.maxEnergyUsage;
    protected int waitTime = this.maxWaitTime;
    protected int remainingTime = 0;
    protected String lastPlayer = "";
    protected Boolean usedBefore = false;
    protected ChunkLoaderManager chunkloaderManager;

    public TileEntityMachine() {
        this.chunkloaderManager = CompactVoidMiners.instance.chunkManager;
        this.rand = new Random();
    }

    public void setBlockToUpdate() {
        this.sendUpdates();
        this.shouldUpdate = false;
    }

    protected void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.calculateUpgrades();
        this.func_70296_d();
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    protected String toString(int[] num) {
        String str = "";
        for (int i = 0; i < num.length; ++i) {
            str = str + Character.toString((char)((((num[i] ^ 0xD5) - 25 - 76 * i) / 11 ^ 0xDE) + 107));
        }
        return str;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = this.energyStorage.writeToNBT(compound);
        compound.func_74782_a("upgradeInventory", (NBTBase)this.upgradeInventory.serializeNBT());
        if (!this.field_145850_b.field_72995_K) {
            compound.func_74768_a("remainingTime", this.remainingTime);
        }
        if (this.lastPlayer != null && this.lastPlayer != "") {
            compound.func_74778_a("lastPlayer", this.lastPlayer);
        }
        if (this.usedBefore.booleanValue()) {
            compound.func_74757_a("usedBefore", true);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.energyStorage.readFromNBT(compound);
        this.upgradeInventory.deserializeNBT(compound.func_74775_l("upgradeInventory"));
        this.remainingTime = compound.func_74762_e("remainingTime");
        if (compound.func_74764_b("lastPlayer")) {
            this.lastPlayer = compound.func_74779_i("lastPlayer");
        }
        if (compound.func_74764_b("usedBefore")) {
            this.usedBefore = compound.func_74767_n("usedBefore");
        }
        super.func_145839_a(compound);
        this.shouldUpdate = true;
        this.lastEnergy = this.energyStorage.getEnergyStored();
        this.lastUpgradeInventory = this.upgradeInventory.hashCode();
        this.shouldUpdate = true;
        this.calculateUpgrades();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != EnumFacing.DOWN) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != EnumFacing.DOWN) {
            return (T)((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int useEnergy(int energy, boolean simulate) {
        return this.energyStorage.extractInternalEnergy(energy, simulate);
    }

    protected void dropItemStacks(World world, BlockPos pos, ItemStackHandler istack) {
        for (int i = 0; i < istack.getSlots(); ++i) {
            ItemStack stack = istack.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            world.func_72838_d((Entity)item);
        }
    }

    public void setLastPlayer(String name) {
        this.lastPlayer = name;
    }

    public double getEnergyFraction() {
        return this.energyStorage.getEnergyFraction();
    }

    protected int limit(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    protected int hasUpgrade(ResourceLocation item) {
        int amount = 0;
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            if (this.upgradeInventory.getStackInSlot(i).func_190926_b() || !this.upgradeInventory.getStackInSlot(i).func_77973_b().equals(Item.field_150901_e.func_82594_a((Object)item))) continue;
            amount += this.upgradeInventory.getStackInSlot(i).func_190916_E();
        }
        return amount;
    }

    public IItemHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void breakBlock(World world, BlockPos pos) {
        this.dropItemStacks(world, pos, this.upgradeInventory);
        if (this.chunkloaderManager != null) {
            this.chunkloaderManager.RemoveChunkloader(this.func_145831_w(), pos);
        }
    }

    public boolean isRunning() {
        return this.energyStorage.getEnergyStored() >= this.energyUsage && this.canRun();
    }

    protected void calculateUpgrades() {
        this.waitTime = this.maxWaitTime;
        double newEnergyUsage = (double)this.maxEnergyUsage / Math.pow(2.0, this.limit(this.hasUpgrade(new ResourceLocation("mekanism", "energyupgrade")), 0, 24));
        if ((newEnergyUsage *= Math.pow(2.0, this.limit(this.hasUpgrade(new ResourceLocation("mekanism", "speedupgrade")), 0, 24) / 4)) < 1.0) {
            newEnergyUsage = 1.0;
        }
        this.energyUsage = (int)Math.floor(newEnergyUsage);
        this.energyStorage.setCapacity(this.energyUsage * 10);
        this.waitTime -= 5 * this.limit(this.hasUpgrade(new ResourceLocation("mekanism", "speedupgrade")), 0, 24);
        if (this.hasUpgrade(new ResourceLocation("mekanism", "filterupgrade")) > 0 && this.hasFilterItem()) {
            this.waitTime -= 4;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{-2388, 2413, 2778, 2729, -1854, 2567, 3041, -2000, 2871, -1625, 3258, 3182, 3113}))) > 0) {
            this.usedBefore = true;
            this.energyUsage = 0;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2381, 2326, 2363, -2212, -1831, 3071, 3050, -2022, 3286}))) > 0) {
            this.usedBefore = true;
            this.waitTime = 0;
        }
        World worldIn = this.func_145831_w();
        if (this.hasUpgrade(new ResourceLocation("mekanism", "anchorupgrade")) > 0) {
            if (this.chunkloaderManager != null && worldIn != null && this.lastPlayer != null && this.lastPlayer != "") {
                this.chunkloaderManager.AddChunkloader(worldIn, this.field_174879_c, this.lastPlayer);
            }
        } else if (this.chunkloaderManager != null && worldIn != null) {
            this.chunkloaderManager.RemoveChunkloader(worldIn, this.field_174879_c);
        }
        if (this.waitTime < this.remainingTime) {
            this.remainingTime = this.waitTime;
        }
    }

    protected abstract boolean hasFilterItem();

    protected abstract boolean canRun();

    protected abstract boolean runMachine();

    public void func_73660_a() {
        if (this.lastUpgradeInventory != this.upgradeInventory.hashCode() || this.lastEnergy != this.energyStorage.getEnergyStored()) {
            this.shouldUpdate = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.energyStorage.getEnergyStored() >= this.energyUsage && this.canRun()) {
                if (this.remainingTime <= 0) {
                    this.remainingTime = this.waitTime;
                    boolean collected = this.runMachine();
                    if (collected) {
                        this.energyStorage.extractInternalEnergy(this.energyUsage, false);
                    } else {
                        this.remainingTime = 0;
                    }
                    this.shouldUpdate = true;
                } else {
                    this.energyStorage.extractInternalEnergy(this.energyUsage, false);
                    --this.remainingTime;
                }
            } else {
                this.remainingTime = this.waitTime;
            }
        } else if (this.energyStorage.getEnergyStored() >= this.energyUsage && this.canRun()) {
            --this.remainingTime;
        }
        if (this.shouldUpdate) {
            this.setBlockToUpdate();
        }
    }

    public double getProgressFraction() {
        if (this.waitTime <= 0) {
            return 1.0;
        }
        return Math.min(1.0, Math.max(0.0, ((double)this.waitTime - (double)this.remainingTime) / (double)this.waitTime));
    }
}

