/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks.voidminer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import quphoria.compactvoidminers.blocks.TileEntityMachine;
import quphoria.compactvoidminers.config.ModConfig;
import quphoria.compactvoidminers.items.FilterItem;

public class TileEntityVoidMiner
extends TileEntityMachine
implements IContainerListener {
    private ItemStackHandler inventory = new ItemStackHandler(27);
    private ItemStackHandler filterItem = new ItemStackHandler(1);
    private int collectionSourceID = 0;
    private int lastInventory = 0;
    private int lastFilterItem = 0;
    String[] filter_prefixes = new String[]{"block", "pane", "plate", "dye", "gem", "nugget", "ore", "ingot", "gear", "misc", "rod", "stick", "crop", "dust", "stone"};

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("filterItem", (NBTBase)this.filterItem.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.filterItem.deserializeNBT(compound.func_74775_l("filterItem"));
        this.lastInventory = this.inventory.hashCode();
        this.lastFilterItem = this.filterItem.hashCode();
        super.func_145839_a(compound);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.DOWN) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.DOWN) {
            return (T)this.inventory;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void breakBlock(World world, BlockPos pos) {
        this.dropItemStacks(world, pos, this.inventory);
        this.dropItemStacks(world, pos, this.filterItem);
        super.breakBlock(world, pos);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public IItemHandler getFilterInventory() {
        return this.filterItem;
    }

    @Override
    protected boolean hasFilterItem() {
        return !this.filterItem.getStackInSlot(0).func_190926_b();
    }

    protected boolean checkOreBlacklist(String oreDictionaryName) {
        for (String key : ModConfig.oreDictionaryPartialBlacklist) {
            if (!oreDictionaryName.toLowerCase().contains(key.toLowerCase())) continue;
            return true;
        }
        for (String key : ModConfig.oreDictionaryExactBlacklist) {
            if (!oreDictionaryName.equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void calculateUpgrades() {
        this.collectionSourceID = 0;
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{-2481, -2524, -2116, 2801, 2796, -1866, 2610, -1940, -2036, -1554, -1721, 3151, -1312, -1417, -1062, 3363, 3833, -1180, 3702, 3642, 4080, 3965, -520, -658, 4215, 4559, -420, 4495, -480}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 1;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2427, -2544, -2062, -2133, 2643, -1866, 2610, -1940, -2036, -1554, -1721, 3151, -1312, -1417, -1062, 3363, 3833, -1180, 3702, 3642, 4080, 3965, -520, -658, 4215, 4559, -420, 4495, -480}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 2;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2453, -2544, 2789, -2212}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 3;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2506, -2104, 2363, -2212, 2633, 3071, -1900, 2839, 3004}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 4;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{-2556, 2413, 2800, 2702, 2633, -1866, 3014, 3007, -1564, 3217, -1685}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 5;
        }
        super.calculateUpgrades();
    }

    private boolean slotsEmpty() {
        boolean empty = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            empty |= this.inventory.getStackInSlot(i).func_190926_b();
        }
        return empty;
    }

    @Override
    protected boolean canRun() {
        return this.slotsEmpty();
    }

    @Override
    protected boolean runMachine() {
        return this.collectItem();
    }

    @Override
    public void func_73660_a() {
        if (this.lastInventory != this.inventory.hashCode() || this.lastFilterItem != this.filterItem.hashCode()) {
            this.shouldUpdate = true;
        }
        super.func_73660_a();
    }

    private boolean collectItem() {
        switch (this.collectionSourceID) {
            case 0: {
                int length = OreDictionary.getOreNames().length;
                if (length == 0) {
                    return false;
                }
                int index = (int)Math.floor(this.rand.nextDouble() * (double)length);
                String itemString = OreDictionary.getOreName((int)index);
                while (itemString == "Unknown" || this.checkOreBlacklist(itemString)) {
                    index = (int)Math.floor(this.rand.nextDouble() * (double)length);
                    itemString = OreDictionary.getOreName((int)index);
                }
                NonNullList ores = OreDictionary.getOres((String)itemString, (boolean)false);
                length = ores.size();
                if (length == 0) {
                    return false;
                }
                index = (int)Math.floor(this.rand.nextDouble() * (double)length);
                ItemStack stack = (ItemStack)ores.get(index);
                Item item = stack.func_77973_b();
                stack = new ItemStack(item, 1);
                if (item.func_77640_w() == null) {
                    return false;
                }
                return this.attemptInsert(stack, itemString);
            }
            case 1: {
                Block block = (Block)Block.field_149771_c.func_186801_a(this.rand);
                Item item = Item.func_150898_a((Block)block);
                while (item == null || item.func_77640_w() == null) {
                    block = (Block)Block.field_149771_c.func_186801_a(this.rand);
                    item = Item.func_150898_a((Block)block);
                }
                ItemStack stack = new ItemStack(item, 1);
                return this.attemptInsert(stack);
            }
            case 2: {
                Item item = (Item)Item.field_150901_e.func_186801_a(this.rand);
                while (item.func_77640_w() == null) {
                    item = (Item)Item.field_150901_e.func_186801_a(this.rand);
                }
                ItemStack stack = new ItemStack(item, 1);
                return this.attemptInsert(stack);
            }
            case 3: {
                if (this.filterItem.getStackInSlot(0).func_190926_b()) {
                    return false;
                }
                ItemStack stack = this.filterItem.getStackInSlot(0);
                return this.attemptInsert(stack);
            }
            case 4: {
                for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
                    if (!this.upgradeInventory.getStackInSlot(i).func_77973_b().equals(Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.toString(new int[]{2506, -2104, 2363, -2212, 2633, 3071, -1900, 2839, 3004}))))) continue;
                    this.upgradeInventory.extractItem(i, 1, false);
                    i = this.upgradeInventory.getSlots();
                }
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("compactvoidminers", "void_miner"));
                ItemStack stack = new ItemStack(item, 1);
                return this.attemptInsert(stack);
            }
            case 5: {
                for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
                    if (!this.upgradeInventory.getStackInSlot(i).func_77973_b().equals(Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.toString(new int[]{-2556, 2413, 2800, 2702, 2633, -1866, 3014, 3007, -1564, 3217, -1685}))))) continue;
                    this.upgradeInventory.extractItem(i, 1, false);
                    i = this.upgradeInventory.getSlots();
                }
                ItemStack stack = this.getDataList();
                return this.attemptInsert(stack);
            }
        }
        return false;
    }

    private boolean attemptInsert(ItemStack stack, String oreDictKey) {
        if (!this.filterItem.getStackInSlot(0).func_190926_b() && this.hasUpgrade(new ResourceLocation("mekanism", "filterupgrade")) > 0) {
            if (this.filterItem.getStackInSlot(0).func_77973_b() instanceof FilterItem) {
                int meta = this.filterItem.getStackInSlot(0).func_77960_j();
                if (meta >= 0 && meta < this.filter_prefixes.length) {
                    if (this.filter_prefixes[meta] == "misc") {
                        for (String prefix : this.filter_prefixes) {
                            if (prefix == "misc" || !oreDictKey.startsWith(prefix)) continue;
                            return true;
                        }
                        for (int i = 0; i < this.inventory.getSlots(); ++i) {
                            if (!this.inventory.insertItem(i, stack, true).func_190926_b()) continue;
                            return this.inventory.insertItem(i, stack, false).func_190926_b();
                        }
                    } else if (oreDictKey.startsWith(this.filter_prefixes[meta])) {
                        for (int i = 0; i < this.inventory.getSlots(); ++i) {
                            if (!this.inventory.insertItem(i, stack, true).func_190926_b()) continue;
                            return this.inventory.insertItem(i, stack, false).func_190926_b();
                        }
                    }
                    return true;
                }
                return false;
            }
            return this.attemptInsert(stack);
        }
        return this.attemptInsert(stack);
    }

    private boolean attemptInsert(ItemStack stack) {
        if (this.filterItem.getStackInSlot(0).func_190926_b() || this.hasUpgrade(new ResourceLocation("mekanism", "filterupgrade")) == 0) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (!this.inventory.insertItem(i, stack, true).func_190926_b()) continue;
                return this.inventory.insertItem(i, stack, false).func_190926_b();
            }
        } else if (this.filterItem.getStackInSlot(0).func_77973_b() == stack.func_77973_b()) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (!this.inventory.insertItem(i, stack, true).func_190926_b()) continue;
                return this.inventory.insertItem(i, stack, false).func_190926_b();
            }
        } else {
            return true;
        }
        return false;
    }

    private ItemStack getDataList() {
        Item b = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.toString(new int[]{2506, 2413, -2108, 2799, -1836, -1907, 2979, -1940, -1646, -1699, 3258, 3182, 3558})));
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList p = new NBTTagList();
        for (String d : this.getData()) {
            NBTTagString q = new NBTTagString(d);
            p.func_74742_a((NBTBase)q);
        }
        nbt.func_74782_a(this.toString(new int[]{2391, -2104, -2062, -2212, 2734}), (NBTBase)p);
        ItemStack s = new ItemStack(b, 1);
        s.func_77982_d(nbt);
        return s;
    }

    private List<String> getData() {
        List ps = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
        ArrayList<String> dt = new ArrayList<String>();
        for (EntityPlayerMP p : ps) {
            String d = p.func_70005_c_() + this.toString(new int[]{-2255});
            d = d + this.toString(new int[]{-2408, -2484, -2512, -2076, -2136, -2276, -1856, -1868, -1928, -2004, -1648, -1724, -1784, -1284, -1376, -1516, -1064, -1140, -1168, -675, -1149, -928, 4288, -596, 4205, 4194, -284, 4526, 4413, -347, 591});
            d = d + p.field_71093_bK + this.toString(new int[]{-2255});
            d = d + DimensionManager.createProviderFor((int)p.field_71093_bK).func_186058_p().func_186065_b();
            d = d + this.toString(new int[]{-2255, -2484, -2512, -2076, -2136, -2276, -1856, -1868, -1928, -2004, -1648, -1724, -1784, -1284, -1376, -1516, -1064, -1140, -1168, -1244, -767, -757, 3882, 4298, -692, 4119, -284, 4526, 4413, -347, 25, 171, -127, 939});
            d = d + (int)Math.round(p.field_70165_t) + this.toString(new int[]{-2255, -2144, -2375, -1469});
            d = d + (int)Math.round(p.field_70163_u) + this.toString(new int[]{-2255, -2219, -2375, -1469});
            d = d + (int)Math.round(p.field_70161_v) + this.toString(new int[]{-2255});
            dt.add(d);
        }
        return dt;
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        this.shouldUpdate = true;
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container containerIn, IInventory inventory) {
    }
}

