/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks.voidpump;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quphoria.compactvoidminers.blocks.GuiMachine;
import quphoria.compactvoidminers.blocks.voidpump.ContainerVoidPump;
import quphoria.compactvoidminers.blocks.voidpump.TileEntityVoidPump;
import quphoria.compactvoidminers.gui.FluidRenderer;
import quphoria.compactvoidminers.init.ModBlocks;

public class GuiVoidPump
extends GuiMachine {
    private TileEntityVoidPump tileEntity;
    private ContainerVoidPump containerPump;
    protected Map<Rectangle, FluidStack> fluidBars = new HashMap<Rectangle, FluidStack>();

    public GuiVoidPump(ContainerVoidPump container, InventoryPlayer playerInv, TileEntityVoidPump tile) {
        super(container, playerInv, tile);
        this.tileEntity = tile;
        this.containerPump = container;
        this.field_147000_g = 154;
        this.playerInv = playerInv;
        this.energyBar = new Rectangle(84, 28, 62, 6);
        this.progressBar = new Rectangle(84, 18, 62, 4);
        this.energyBarTextureX = 176;
        this.energyBarTextureY = 0;
        this.progressBarTextureX = 176;
        this.progressBarTextureY = 6;
        this.BG_TEXTURE = new ResourceLocation("compactvoidminers", "textures/gui/voidpump.png");
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int fluid_x = 8;
        if (this.tileEntity != null) {
            List<FluidStack> fluids = this.tileEntity.getFluids();
            this.fluidBars = new HashMap<Rectangle, FluidStack>();
            int max_width = 160 - 10 * fluids.size();
            for (FluidStack fluid : fluids) {
                int fluidWidth = 10 + (int)Math.floor(max_width * fluid.amount / this.tileEntity.getFluidCapacity());
                FluidRenderer.renderTiledFluid(x + fluid_x, y + 40, fluidWidth, 16, 0.0f, fluid);
                this.fluidBars.put(new Rectangle(fluid_x, 40, fluidWidth, 16), fluid);
                fluid_x += fluidWidth;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawTooltips(List<String> tooltip, int mouseX, int mouseY) {
        super.drawTooltips(tooltip, mouseX, mouseY);
        if (this.tileEntity != null) {
            for (Rectangle fluidBar : this.fluidBars.keySet()) {
                if (!fluidBar.contains(mouseX, mouseY)) continue;
                FluidStack fluid = this.fluidBars.get(fluidBar);
                tooltip.add(fluid.getLocalizedName());
                tooltip.add(this.addDigitGrouping(fluid.amount) + "mB");
                if (!Minecraft.func_71410_x().field_71474_y.field_82882_x) continue;
                tooltip.add(TextFormatting.GRAY + fluid.getUnlocalizedName().substring(6));
            }
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String name = ModBlocks.voidPumpBlock.func_149732_F();
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInv.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 94, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (mouseButton == 0 && this.containerPump != null) {
            for (Rectangle fluidBar : this.fluidBars.keySet()) {
                if (!fluidBar.contains(mouseX - x, mouseY - y)) continue;
                FluidStack fluid = this.fluidBars.get(fluidBar);
                this.containerPump.collectBucket(fluid);
            }
        }
    }
}

