/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks.voidpump;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import quphoria.compactvoidminers.blocks.TileEntityMachine;
import quphoria.compactvoidminers.config.ModConfig;
import quphoria.compactvoidminers.fluid.MultiFluidStorage;

public class TileEntityVoidPump
extends TileEntityMachine
implements IContainerListener {
    private MultiFluidStorage fluidTank = new MultiFluidStorage(10000, 10);
    private ItemStackHandler filterItem = new ItemStackHandler(1);
    private int collectionSourceID = 0;
    private int lastFluids = 0;
    private int lastFilterItem = 0;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("filterItem", (NBTBase)this.filterItem.serializeNBT());
        compound = this.fluidTank.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.filterItem.deserializeNBT(compound.func_74775_l("filterItem"));
        this.fluidTank.readFromNBT(compound);
        this.lastFluids = ((Object)((Object)this.fluidTank)).hashCode();
        this.lastFilterItem = this.filterItem.hashCode();
        super.func_145839_a(compound);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != EnumFacing.DOWN) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != EnumFacing.DOWN) {
            return (T)((Object)this.fluidTank);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void breakBlock(World world, BlockPos pos) {
        this.dropItemStacks(world, pos, this.filterItem);
        super.breakBlock(world, pos);
    }

    public IItemHandler getFilterInventory() {
        return this.filterItem;
    }

    @Override
    protected void calculateUpgrades() {
        this.collectionSourceID = 0;
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2453, -2544, 2789, -2212}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 1;
        }
        super.calculateUpgrades();
    }

    private boolean tankSpace() {
        return this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity();
    }

    @Override
    protected boolean canRun() {
        return this.tankSpace();
    }

    @Override
    protected boolean runMachine() {
        return this.collectFluid();
    }

    public int getFluidLevel() {
        return this.fluidTank.getFluidAmount();
    }

    public int getMaxFluidLevel() {
        return this.fluidTank.getCapacity();
    }

    @Override
    protected boolean hasFilterItem() {
        return this.getFilterFluid() != null;
    }

    protected boolean checkBlacklist(String fluidName) {
        for (String key : ModConfig.oreDictionaryPartialBlacklist) {
            if (!fluidName.toLowerCase().contains(key.toLowerCase())) continue;
            return true;
        }
        for (String key : ModConfig.oreDictionaryExactBlacklist) {
            if (!fluidName.equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        if (this.lastFluids != ((Object)((Object)this.fluidTank)).hashCode() || this.lastFilterItem != this.filterItem.hashCode()) {
            this.shouldUpdate = true;
        }
        super.func_73660_a();
    }

    private boolean collectFluid() {
        switch (this.collectionSourceID) {
            case 0: {
                Map registeredFluids = FluidRegistry.getRegisteredFluids();
                Object[] registeredFluidNames = registeredFluids.keySet().toArray();
                Fluid fluid = (Fluid)registeredFluids.get(registeredFluidNames[this.rand.nextInt(registeredFluidNames.length)]);
                while (this.checkBlacklist(fluid.getUnlocalizedName().substring(6))) {
                    fluid = (Fluid)registeredFluids.get(registeredFluidNames[this.rand.nextInt(registeredFluidNames.length)]);
                }
                FluidStack stack = new FluidStack(fluid, 1000);
                return this.attemptInsert(stack);
            }
            case 1: {
                Fluid fluid = this.getFilterFluid();
                if (fluid == null) {
                    return false;
                }
                FluidStack stack = new FluidStack(fluid, 1000);
                return this.attemptInsert(stack);
            }
        }
        return false;
    }

    private Fluid getFilterFluid() {
        ItemStack filterStack = this.filterItem.getStackInSlot(0);
        Item filterI = filterStack.func_77973_b();
        if (!(filterI instanceof UniversalBucket)) {
            return null;
        }
        UniversalBucket filter = (UniversalBucket)filterI;
        return filter.getFluid(filterStack).getFluid();
    }

    public int getFluidCapacity() {
        return this.fluidTank.getCapacity();
    }

    public List<FluidStack> getFluids() {
        return this.fluidTank.getFluids();
    }

    public ItemStack getFluidBucket(FluidStack targetFluid) {
        return this.fluidTank.getFluidBucket(targetFluid);
    }

    private boolean attemptInsert(FluidStack stack) {
        if (this.getFilterFluid() == null || this.hasUpgrade(new ResourceLocation("mekanism", "filterupgrade")) == 0) {
            return this.fluidTank.fillInternal(stack, true) > 0;
        }
        if (this.getFilterFluid() == stack.getFluid()) {
            return this.fluidTank.fillInternal(stack, true) > 0;
        }
        return true;
    }

    public void getFluidBucket(FluidStack fluid, EntityPlayerMP player) {
        ItemStack fluidBucket;
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b().equals(Item.field_150901_e.func_82594_a((Object)new ResourceLocation("bucket"))) && !(fluidBucket = this.getFluidBucket(fluid)).func_190926_b()) {
            if (heldItem.func_190916_E() == 1) {
                player.field_71071_by.func_70437_b(fluidBucket);
            } else {
                heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                player.field_71071_by.func_70437_b(heldItem);
                if (!player.field_71071_by.func_70441_a(fluidBucket)) {
                    player.func_146097_a(fluidBucket, false, true);
                }
            }
            this.setBlockToUpdate();
            player.func_71113_k();
        }
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        this.shouldUpdate = true;
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container containerIn, IInventory inventory) {
    }
}

