/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.chunkloader;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import quphoria.compactvoidminers.CompactVoidMiners;
import quphoria.compactvoidminers.chunkloader.WorldSavedDataChunks;
import quphoria.compactvoidminers.config.ModConfig;

public class ChunkLoaderManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    List<ForgeChunkManager.Ticket> ChunkTickets = new ArrayList<ForgeChunkManager.Ticket>();
    WorldSavedDataChunks chunkData;

    public void AddChunkTicket(World world, Chunk chunk, String lastPlayer) {
        this.chunkData = WorldSavedDataChunks.get(world);
        ForgeChunkManager.Ticket newTicket = ForgeChunkManager.requestPlayerTicket((Object)CompactVoidMiners.instance, (String)lastPlayer, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (newTicket != null) {
            NBTTagCompound nbt = newTicket.getModData();
            nbt.func_74768_a("ChunkX", chunk.func_76632_l().field_77276_a);
            nbt.func_74768_a("ChunkZ", chunk.func_76632_l().field_77275_b);
            int radius = ModConfig.ChunkloaderRadius;
            for (int x = chunk.func_76632_l().field_77276_a - radius; x <= chunk.func_76632_l().field_77276_a + radius; ++x) {
                for (int z = chunk.func_76632_l().field_77275_b - radius; z <= chunk.func_76632_l().field_77275_b + radius; ++z) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)newTicket, (ChunkPos)new ChunkPos(x, z));
                }
            }
            this.ChunkTickets.add(newTicket);
        } else {
            String position = (chunk.field_76635_g << 4) + 7 + ", " + ((chunk.field_76647_h << 4) + 7);
            TextComponentString message = new TextComponentString("Player chunk limit reached, unable to load chunks around " + position);
            message.func_150256_b().func_150238_a(TextFormatting.RED);
            world.func_73046_m().func_184103_al().func_152612_a(lastPlayer).func_145747_a((ITextComponent)message);
        }
    }

    public void AddExistingTicket(ForgeChunkManager.Ticket ticket, World world, int ChunkX, int ChunkZ) {
        int radius = ModConfig.ChunkloaderRadius;
        for (int x = ChunkX - radius; x <= ChunkX + radius; ++x) {
            for (int z = ChunkZ - radius; z <= ChunkZ + radius; ++z) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(x, z));
            }
        }
    }

    public void RemoveBlockTicket(World world, Chunk chunk) {
        this.validateTickets(world);
    }

    public void AddChunkloader(World world, BlockPos pos, String lastPlayer) {
        if (!world.field_72995_K) {
            this.chunkData = WorldSavedDataChunks.get(world);
            Chunk chunk = world.func_175726_f(pos);
            if (!this.chunkData.getBlockData(chunk.func_76632_l(), pos, "Chunkloader")) {
                int chunkCount = this.chunkData.getChunkCount(world, chunk.func_76632_l(), "Chunkloader");
                if (chunkCount == 0) {
                    this.AddChunkTicket(world, chunk, lastPlayer);
                }
                this.chunkData.setBlockData(chunk.func_76632_l(), pos, "Chunkloader", true);
            }
        }
    }

    public void RemoveChunkloader(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            this.chunkData = WorldSavedDataChunks.get(world);
            Chunk chunk = world.func_175726_f(pos);
            if (this.chunkData.getBlockData(chunk.func_76632_l(), pos, "Chunkloader")) {
                this.chunkData.setBlockData(chunk.func_76632_l(), pos, "Chunkloader", false);
                int chunkCount = this.chunkData.getChunkCount(world, chunk.func_76632_l(), "Chunkloader");
                if (chunkCount == 0) {
                    this.RemoveBlockTicket(world, chunk);
                }
            }
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        this.ChunkTickets = new ArrayList<ForgeChunkManager.Ticket>(tickets);
        for (ForgeChunkManager.Ticket ticket : this.ChunkTickets) {
            NBTTagCompound nbt = ticket.getModData();
            if (nbt == null) continue;
            int ChunkX = nbt.func_74762_e("ChunkX");
            int ChunkZ = nbt.func_74762_e("ChunkZ");
            this.AddExistingTicket(ticket, world, ChunkX, ChunkZ);
        }
        this.validateTickets(world);
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return tickets;
    }

    public void validateTickets(World world) {
        this.chunkData = WorldSavedDataChunks.get(world);
        ArrayList<ForgeChunkManager.Ticket> invalidTickets = new ArrayList<ForgeChunkManager.Ticket>();
        if (!world.field_72995_K) {
            int i;
            for (i = 0; i < this.ChunkTickets.size(); ++i) {
                ChunkPos[] chunks = (ChunkPos[])this.ChunkTickets.get(i).getChunkList().toArray((Object[])new ChunkPos[0]);
                boolean validTicket = false;
                for (int j = 0; j < chunks.length; ++j) {
                    validTicket |= this.chunkData.getChunkCount(world, chunks[j], "Chunkloader") > 0;
                }
                if (validTicket) continue;
                invalidTickets.add(this.ChunkTickets.get(i));
            }
            for (i = 0; i < invalidTickets.size(); ++i) {
                ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)invalidTickets.get(i);
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                this.ChunkTickets.remove(ticket);
            }
        }
    }
}

