/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.chunkloader;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import quphoria.compactvoidminers.blocks.BlockMachineTileEntity;

public class WorldSavedDataChunks
extends WorldSavedData {
    public static final String NAME = "compactvoidminers_WorldData";
    public Map<ChunkPos, Map<BlockPos, NBTTagCompound>> worldData;

    public WorldSavedDataChunks(String name) {
        super(name);
        if (this.worldData == null) {
            this.worldData = new HashMap<ChunkPos, Map<BlockPos, NBTTagCompound>>();
        }
    }

    public WorldSavedDataChunks() {
        super(NAME);
        if (this.worldData == null) {
            this.worldData = new HashMap<ChunkPos, Map<BlockPos, NBTTagCompound>>();
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagCompound chunks = nbt.func_74775_l("chunkloaders");
        this.worldData = new HashMap<ChunkPos, Map<BlockPos, NBTTagCompound>>();
        for (String c_pos : chunks.func_150296_c()) {
            HashMap<BlockPos, NBTTagCompound> chunkData = new HashMap<BlockPos, NBTTagCompound>();
            NBTTagCompound chunkNBT = chunks.func_74775_l(c_pos);
            for (String pos : chunkNBT.func_150296_c()) {
                chunkData.put(this.parseBlockString(pos), chunkNBT.func_74775_l(pos));
            }
            this.worldData.put(this.parseChunkString(c_pos), chunkData);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagCompound chunks = new NBTTagCompound();
        for (ChunkPos c_pos : this.worldData.keySet()) {
            Map<BlockPos, NBTTagCompound> chunkData = this.worldData.get(c_pos);
            NBTTagCompound chunkNBT = new NBTTagCompound();
            for (BlockPos pos : chunkData.keySet()) {
                chunkNBT.func_74782_a(this.cleanBlockPos(pos), (NBTBase)chunkData.get(pos));
            }
            chunks.func_74782_a(c_pos.toString(), (NBTBase)chunkNBT);
        }
        nbt.func_74782_a("chunkloaders", (NBTBase)chunks);
        return nbt;
    }

    public void setBlockData(ChunkPos c_pos, BlockPos pos, String key, boolean data) {
        NBTTagCompound nbt;
        Map<BlockPos, NBTTagCompound> chunkData = this.worldData.get(c_pos);
        if (chunkData == null) {
            chunkData = new HashMap<BlockPos, NBTTagCompound>();
        }
        if ((nbt = chunkData.get(pos)) == null && data) {
            nbt = new NBTTagCompound();
        }
        if (data) {
            nbt.func_74757_a(key, true);
            chunkData.put(pos, nbt);
        } else {
            chunkData.remove(pos);
        }
        if (chunkData.size() == 0) {
            this.worldData.remove(c_pos);
        } else {
            this.worldData.put(c_pos, chunkData);
        }
        this.func_76185_a();
    }

    public boolean getBlockData(ChunkPos c_pos, BlockPos pos, String key) {
        Map<BlockPos, NBTTagCompound> chunkData = this.worldData.get(c_pos);
        if (chunkData == null) {
            return false;
        }
        NBTTagCompound nbt = chunkData.get(pos);
        if (nbt == null) {
            return false;
        }
        return nbt.func_74767_n(key);
    }

    public int getChunkCount(World world, ChunkPos c_pos, String key) {
        Map<BlockPos, NBTTagCompound> chunkData = this.worldData.get(c_pos);
        if (chunkData == null) {
            return 0;
        }
        int blockCount = 0;
        for (BlockPos pos : chunkData.keySet()) {
            if (!chunkData.get(pos).func_74767_n(key)) continue;
            if (world.func_180495_p(pos).func_177230_c() instanceof BlockMachineTileEntity) {
                ++blockCount;
                continue;
            }
            NBTTagCompound nbt = chunkData.get(pos);
            chunkData.remove(pos, nbt);
            if (chunkData.size() == 0) {
                this.worldData.remove(c_pos);
            } else {
                this.worldData.put(c_pos, chunkData);
            }
            this.func_76185_a();
        }
        return blockCount;
    }

    public static WorldSavedDataChunks get(World w) {
        MapStorage s = w.getPerWorldStorage();
        WorldSavedDataChunks d = (WorldSavedDataChunks)s.func_75742_a(WorldSavedDataChunks.class, NAME);
        if (d == null) {
            d = new WorldSavedDataChunks();
            s.func_75745_a(NAME, (WorldSavedData)d);
        }
        return d;
    }

    private ChunkPos parseChunkString(String position) {
        position = position.replaceAll("[\\[\\]]", "");
        String[] coordinates = position.split(", ");
        return new ChunkPos(Integer.parseInt(coordinates[0], 10), Integer.parseInt(coordinates[1], 10));
    }

    private String cleanBlockPos(BlockPos pos) {
        return "[" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "]";
    }

    private BlockPos parseBlockString(String position) {
        position = position.replaceAll("[\\[\\]]", "");
        String[] coordinates = position.split(", ");
        return new BlockPos(Integer.parseInt(coordinates[0], 10), Integer.parseInt(coordinates[1], 10), Integer.parseInt(coordinates[2], 10));
    }
}

