/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.fluid;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import quphoria.compactvoidminers.blocks.TileEntityMachine;

public class MultiFluidStorage
extends FluidTank {
    int maxFluids = 1;
    List<FluidStack> fluids;

    public MultiFluidStorage(int capacity, int maxFluids) {
        super(capacity);
        this.maxFluids = maxFluids;
        this.canFill = false;
        this.fluids = new ArrayList<FluidStack>();
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("Fluids")) {
            this.fluids = new ArrayList<FluidStack>();
        } else {
            this.fluids = new ArrayList<FluidStack>();
            NBTTagList nbt_fluids = nbt.func_150295_c("Fluids", 10);
            for (int i = 0; i < nbt_fluids.func_74745_c(); ++i) {
                NBTTagCompound nbt_fluid = nbt_fluids.func_150305_b(i);
                this.fluids.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt_fluid));
            }
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.fluids.size() > 0) {
            NBTTagList nbt_fluids = new NBTTagList();
            for (FluidStack fluid : this.fluids) {
                NBTTagCompound nbt_fluid = new NBTTagCompound();
                fluid.writeToNBT(nbt_fluid);
                nbt_fluids.func_74742_a((NBTBase)nbt_fluid);
            }
            nbt.func_74782_a("Fluids", (NBTBase)nbt_fluids);
        }
        return nbt;
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.fluids.size() == 0) {
            return null;
        }
        return this.fluids.get(0);
    }

    public int getFluidAmount() {
        int fluidamount = 0;
        for (FluidStack fluid : this.fluids) {
            fluidamount += fluid.amount;
        }
        return fluidamount;
    }

    public ItemStack getFluidBucket(FluidStack targetFluid) {
        for (FluidStack fluid : this.fluids) {
            if (!fluid.getFluid().equals(targetFluid.getFluid()) || fluid.amount < 1000) continue;
            ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)targetFluid);
            if (!bucket.func_190926_b()) {
                fluid.amount -= 1000;
                if (fluid.amount <= 0) {
                    this.fluids.remove(fluid);
                }
                this.onContentsChanged();
                return bucket;
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public List<FluidStack> getFluids() {
        ArrayList<FluidStack> copyFluids = new ArrayList<FluidStack>();
        for (FluidStack fluid : this.fluids) {
            copyFluids.add(new FluidStack(fluid.getFluid(), fluid.amount));
        }
        return copyFluids;
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        if (!doFill) {
            if (this.fluid == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!this.fluid.isFluidEqual(resource)) {
                if (this.maxFluids > this.fluids.size()) {
                    return Math.min(this.capacity - this.getFluidAmount(), resource.amount);
                }
                return 0;
            }
            return Math.min(this.capacity - this.getFluidAmount(), resource.amount);
        }
        for (FluidStack fluid : this.fluids) {
            if (fluid.getFluid() != resource.getFluid()) continue;
            int filled = this.capacity - this.getFluidAmount();
            if (resource.amount < filled) {
                filled = resource.amount;
            }
            fluid.amount += filled;
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, filled));
            }
            return filled;
        }
        if (this.maxFluids > this.fluids.size()) {
            FluidStack fluid = new FluidStack(resource, Math.min(this.capacity - this.getFluidAmount(), resource.amount));
            this.onContentsChanged();
            this.fluids.add(fluid);
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, fluid.amount));
            }
            return fluid.amount;
        }
        return 0;
    }

    @Nullable
    public FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrainFluidType(resource)) {
            return null;
        }
        return this.drainInternal(resource, resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drainInternal(FluidStack resource, int maxDrain, boolean doDrain) {
        if (resource == null || maxDrain <= 0 || !this.canDrainFluidType(resource)) {
            return null;
        }
        FluidStack fluid = null;
        for (FluidStack _fluid : this.fluids) {
            if (_fluid.getFluid() != resource.getFluid()) continue;
            fluid = _fluid;
        }
        if (fluid == null) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                this.fluids.remove(fluid);
            }
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, drained));
            }
        }
        return stack;
    }

    private void removeEmpty() {
        for (FluidStack fluid : this.fluids) {
            if (fluid != null && fluid.amount != 0) continue;
            this.fluids.remove(fluid);
        }
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (!this.canDrainFluidType(resource)) {
            return null;
        }
        FluidStack dr = this.drainInternal(resource, doDrain);
        return dr;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack resource = this.getFluid();
        if (!this.canDrainFluidType(resource)) {
            return null;
        }
        FluidStack dr = this.drainInternal(resource, maxDrain, doDrain);
        return dr;
    }

    public boolean canDrainFluidType(@Nullable FluidStack resource) {
        if (resource == null || !this.canDrain()) {
            return false;
        }
        for (FluidStack fluid : this.fluids) {
            if (fluid.getFluid() != resource.getFluid()) continue;
            return true;
        }
        return false;
    }

    protected void onContentsChanged() {
        this.removeEmpty();
        if (this.tile != null) {
            ((TileEntityMachine)this.tile).setBlockToUpdate();
        }
    }
}

