/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.init;

import java.util.Collections;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import quphoria.compactvoidminers.init.ModBlocks;
import quphoria.compactvoidminers.items.FilterItem;
import quphoria.compactvoidminers.items.ItemBasic;

@Mod.EventBusSubscriber(modid="compactvoidminers")
public class ModItems {
    public static final CreativeTabs tabCompactVoidMiners = new CreativeTabs("tabCompactVoidMiners"){
        private ItemSorter itemSorter = new ItemSorter();

        public ItemStack func_78016_d() {
            return new ItemStack((Block)ModBlocks.voidMinerBlock);
        }

        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            Collections.sort(items, this.itemSorter);
        }

        class ItemSorter
        implements Comparator<ItemStack> {
            ItemSorter() {
            }

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                Item item1 = o1.func_77973_b();
                Item item2 = o2.func_77973_b();
                if (item1 instanceof ItemBlock && !(item2 instanceof ItemBlock)) {
                    return -1;
                }
                if (item2 instanceof ItemBlock && !(item1 instanceof ItemBlock)) {
                    return 1;
                }
                if (item1 instanceof ItemBasic && !(item2 instanceof ItemBasic)) {
                    return -1;
                }
                if (item2 instanceof ItemBasic && !(item1 instanceof ItemBasic)) {
                    return 1;
                }
                if (item1 == item2) {
                    return item1.getMetadata(o1) < item2.getMetadata(o2) ? -1 : 1;
                }
                String displayName1 = o1.func_82833_r();
                String displayName2 = o2.func_82833_r();
                int result = displayName1.compareToIgnoreCase(displayName2);
                return result;
            }
        }
    };
    static Item blank_filter;
    static Item item_filter;

    public static void preInit() {
        blank_filter = new ItemBasic("blank_filter").func_77625_d(8);
        item_filter = new FilterItem("item_filter").func_77625_d(8);
    }

    public static void init() {
        blank_filter.func_77637_a(tabCompactVoidMiners);
        item_filter.func_77637_a(tabCompactVoidMiners);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void itemColorHandlers(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        IItemColor item_filter_color = new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex > 0) {
                    return -1;
                }
                return ((FilterItem)stack.func_77973_b()).getColor(stack);
            }
        };
        colors.func_186730_a(item_filter_color, new Item[]{item_filter});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{blank_filter});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{item_filter});
    }

    @SubscribeEvent
    public static void registerRenders(ModelRegistryEvent event) {
        ModItems.registerRender(blank_filter);
        ModItems.registerMultipleRenders(item_filter, 15);
    }

    private static void registerRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private static void registerMultipleRenders(Item item, int variants) {
        for (int i = 0; i < variants; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory-" + i));
        }
    }
}

