/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import de.maxhenkel.voicechat.BuildConstants;
import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.server.ServerVoiceEvents;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Voicechat {
    public static final String MODID = "voicechat";
    public static final Logger LOGGER = LogManager.getLogger((String)"voicechat");
    public static ServerVoiceEvents SERVER;
    public static ServerConfig SERVER_CONFIG;
    public static int COMPATIBILITY_VERSION;
    public static final Pattern GROUP_REGEX;

    public void initialize() {
        if (Voicechat.debugMode()) {
            LOGGER.warn("Running in debug mode - Don't leave this enabled in production!");
        }
        LOGGER.info("Compatibility version {}", (Object)COMPATIBILITY_VERSION);
        CommonCompatibilityManager.INSTANCE.getNetManager().init();
        SERVER = new ServerVoiceEvents();
        PluginManager.instance().init();
    }

    public static void logDebug(String message, Object ... objects) {
        if (Voicechat.debugMode()) {
            LOGGER.info(message, objects);
        }
    }

    public static boolean debugMode() {
        return CommonCompatibilityManager.INSTANCE.isDevEnvironment() || System.getProperty("voicechat.debug") != null;
    }

    static {
        COMPATIBILITY_VERSION = BuildConstants.COMPATIBILITY_VERSION;
        GROUP_REGEX = Pattern.compile("^[^\"\\n\\r\\t\\s][^\"\\n\\r\\t]{0,15}$");
    }
}

