/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client.speaker;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.AudioChannelConfig;
import de.maxhenkel.voicechat.voice.client.DataLines;
import de.maxhenkel.voicechat.voice.client.PositionalAudioUtils;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.util.math.Vec3d;

public abstract class JavaSpeakerBase
implements Speaker {
    private SourceDataLine speaker;
    private FloatControl gainControl;
    private SpeakerWatchdogThread speakerWatchdogThread;

    @Override
    public void open() throws SpeakerException {
        this.speaker = DataLines.getSpeaker(AudioChannelConfig.STEREO_FORMAT);
        if (this.speaker == null) {
            throw new SpeakerException("Could not open speaker");
        }
        try {
            this.speaker.open(AudioChannelConfig.STEREO_FORMAT);
        }
        catch (LineUnavailableException e) {
            throw new SpeakerException(e.getMessage());
        }
        this.gainControl = (FloatControl)this.speaker.getControl(FloatControl.Type.MASTER_GAIN);
        this.speakerWatchdogThread = new SpeakerWatchdogThread();
        this.speakerWatchdogThread.start();
    }

    private int getAvailableSamples() {
        return this.speaker.getBufferSize() - this.speaker.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(short[] data, float volume, @Nullable Vec3d position, @Nullable String category, float maxDistance) {
        SourceDataLine sourceDataLine = this.speaker;
        synchronized (sourceDataLine) {
            this.playInternal(data, volume, position, category, maxDistance);
        }
    }

    private void playInternal(short[] data, float volume, @Nullable Vec3d position, @Nullable String category, float maxDistance) {
        if (this.getAvailableSamples() <= 0) {
            byte[] emptyData = new byte[Math.min(3840 * VoicechatClient.CLIENT_CONFIG.outputBufferSize.get(), this.speaker.getBufferSize() - 3840)];
            this.speaker.write(emptyData, 0, emptyData.length);
        }
        if (this.getAvailableSamples() > AudioChannelConfig.maxSpeakerBufferSize()) {
            Voicechat.logDebug("Skipping playing audio to avoid delay", new Object[0]);
            return;
        }
        short[] stereo = this.convertToStereo(data, position);
        byte[] bytes = Utils.shortsToBytes(stereo);
        float distanceVolume = position == null ? 1.0f : PositionalAudioUtils.getDistanceVolume(maxDistance, position);
        this.gainControl.setValue(Math.min(Math.max(Utils.percentageToDB(volume * distanceVolume), this.gainControl.getMinimum()), this.gainControl.getMaximum()));
        this.speaker.write(bytes, 0, bytes.length);
        this.speaker.start();
    }

    protected abstract short[] convertToStereo(short[] var1, @Nullable Vec3d var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.speakerWatchdogThread.interrupt();
            this.speakerWatchdogThread.join(20L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SourceDataLine sourceDataLine = this.speaker;
        synchronized (sourceDataLine) {
            this.speaker.stop();
            this.speaker.flush();
            this.speaker.close();
        }
    }

    private class SpeakerWatchdogThread
    extends Thread {
        public SpeakerWatchdogThread() {
            super("Speaker Watchdog");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    return;
                }
                SourceDataLine sourceDataLine = JavaSpeakerBase.this.speaker;
                synchronized (sourceDataLine) {
                    if (JavaSpeakerBase.this.getAvailableSamples() <= 0) {
                        JavaSpeakerBase.this.speaker.stop();
                    }
                }
            }
        }
    }
}

