/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;

public class LocationSoundPacket
extends SoundPacket<LocationSoundPacket> {
    protected Vec3d location;
    protected float distance;

    public LocationSoundPacket(UUID sender, Vec3d location, byte[] data, long sequenceNumber, float distance, @Nullable String category) {
        super(sender, data, sequenceNumber, category);
        this.location = location;
        this.distance = distance;
    }

    public LocationSoundPacket(UUID sender, short[] data, Vec3d location, float distance, @Nullable String category) {
        super(sender, data, category);
        this.location = location;
        this.distance = distance;
    }

    public LocationSoundPacket() {
    }

    public Vec3d getLocation() {
        return this.location;
    }

    public float getDistance() {
        return this.distance;
    }

    @Override
    public LocationSoundPacket fromBytes(PacketBuffer buf) {
        LocationSoundPacket soundPacket = new LocationSoundPacket();
        soundPacket.sender = buf.func_179253_g();
        soundPacket.location = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        soundPacket.data = buf.func_179251_a();
        soundPacket.sequenceNumber = buf.readLong();
        soundPacket.distance = buf.readFloat();
        byte data = buf.readByte();
        if (this.hasFlag(data, (byte)2)) {
            soundPacket.category = buf.func_150789_c(16);
        }
        return soundPacket;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.sender);
        buf.writeDouble(this.location.field_72450_a);
        buf.writeDouble(this.location.field_72448_b);
        buf.writeDouble(this.location.field_72449_c);
        buf.func_179250_a(this.data);
        buf.writeLong(this.sequenceNumber);
        buf.writeFloat(this.distance);
        byte data = 0;
        if (this.category != null) {
            data = this.setFlag(data, (byte)2);
        }
        buf.writeByte((int)data);
        if (this.category != null) {
            buf.func_180714_a(this.category);
        }
    }
}

