/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.RawUdpPacket;
import de.maxhenkel.voicechat.api.VoicechatSocket;
import de.maxhenkel.voicechat.debug.CooldownTimer;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.GroupManager;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import de.maxhenkel.voicechat.voice.server.ServerCategoryManager;
import de.maxhenkel.voicechat.voice.server.ServerWorldUtils;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class Server
extends Thread {
    private final Map<UUID, ClientConnection> connections;
    private final Map<UUID, UUID> secrets;
    private int port;
    private final MinecraftServer server;
    private VoicechatSocket socket;
    private final ProcessThread processThread;
    private final BlockingQueue<RawUdpPacket> packetQueue;
    private final PingManager pingManager;
    private final PlayerStateManager playerStateManager;
    private final GroupManager groupManager;
    private final ServerCategoryManager categoryManager;

    public Server(MinecraftServer server) {
        if (server.func_71262_S()) {
            int configPort = Voicechat.SERVER_CONFIG.voiceChatPort.get();
            if (configPort < 0) {
                Voicechat.LOGGER.info("Using the Minecraft servers port as voice chat port");
                this.port = ((DedicatedServer)server).func_71234_u();
            } else {
                this.port = configPort;
            }
        } else {
            this.port = 0;
        }
        this.server = server;
        this.socket = PluginManager.instance().getSocketImplementation(server);
        this.connections = new HashMap<UUID, ClientConnection>();
        this.secrets = new HashMap<UUID, UUID>();
        this.packetQueue = new LinkedBlockingQueue<RawUdpPacket>();
        this.pingManager = new PingManager(this);
        this.playerStateManager = new PlayerStateManager(this);
        this.groupManager = new GroupManager(this);
        this.categoryManager = new ServerCategoryManager(this);
        this.setDaemon(true);
        this.setName("VoiceChatServerThread");
        this.processThread = new ProcessThread();
        this.processThread.start();
    }

    @Override
    public void run() {
        try {
            this.socket.open(this.port, Voicechat.SERVER_CONFIG.voiceChatBindAddress.get());
            Voicechat.LOGGER.info("Server started at port {}", (Object)this.socket.getLocalPort());
            while (!this.socket.isClosed()) {
                try {
                    this.packetQueue.add(this.socket.read());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Voice chat server error {}", (Object)e.getMessage());
        }
    }

    public void changePort(int port) throws Exception {
        VoicechatSocket newSocket = PluginManager.instance().getSocketImplementation(this.server);
        newSocket.open(port, Voicechat.SERVER_CONFIG.voiceChatBindAddress.get());
        VoicechatSocket old = this.socket;
        this.socket = newSocket;
        this.port = port;
        old.close();
        this.connections.clear();
        this.secrets.clear();
    }

    public UUID getSecret(UUID playerUUID) {
        if (this.hasSecret(playerUUID)) {
            return this.secrets.get(playerUUID);
        }
        SecureRandom r = new SecureRandom();
        UUID secret = new UUID(r.nextLong(), r.nextLong());
        this.secrets.put(playerUUID, secret);
        return secret;
    }

    public boolean hasSecret(UUID playerUUID) {
        return this.secrets.containsKey(playerUUID);
    }

    public void disconnectClient(UUID playerUUID) {
        this.connections.remove(playerUUID);
        this.secrets.remove(playerUUID);
        PluginManager.instance().onPlayerDisconnected(playerUUID);
    }

    public void close() {
        this.socket.close();
        this.processThread.close();
        PluginManager.instance().onServerStopped();
    }

    public boolean isClosed() {
        return !this.processThread.running;
    }

    private void processMicPacket(EntityPlayerMP player, PlayerState state, MicPacket packet) throws Exception {
        if (state.hasGroup()) {
            this.processGroupPacket(state, player, packet);
            if (Voicechat.SERVER_CONFIG.openGroups.get().booleanValue()) {
                this.processProximityPacket(state, player, packet);
            }
            return;
        }
        this.processProximityPacket(state, player, packet);
    }

    private void processGroupPacket(PlayerState senderState, EntityPlayerMP sender, MicPacket packet) throws Exception {
        ClientGroup group = senderState.getGroup();
        if (group == null) {
            return;
        }
        GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getUuid(), packet.getData(), packet.getSequenceNumber(), null);
        NetworkMessage soundMessage = new NetworkMessage(groupSoundPacket);
        for (PlayerState state : this.playerStateManager.getStates()) {
            EntityPlayerMP p;
            ClientConnection connection;
            if (!group.equals(state.getGroup()) || senderState.getUuid().equals(state.getUuid()) || (connection = this.getConnection(state.getUuid())) == null || (p = this.server.func_184103_al().func_177451_a(senderState.getUuid())) == null || PluginManager.instance().onSoundPacket(sender, senderState, p, state, groupSoundPacket, "group")) continue;
            connection.send(this, soundMessage);
        }
    }

    private void processProximityPacket(PlayerState senderState, EntityPlayerMP sender, MicPacket packet) throws Exception {
        ClientGroup group = senderState.getGroup();
        float distance = Utils.getDefaultDistance();
        SoundPacket soundPacket = null;
        String source = null;
        if (sender.func_175149_v()) {
            EntityPlayerMP spectatingPlayer;
            Entity camera;
            if (Voicechat.SERVER_CONFIG.spectatorPlayerPossession.get().booleanValue() && (camera = sender.func_175398_C()) instanceof EntityPlayerMP && (spectatingPlayer = (EntityPlayerMP)camera) != sender) {
                PlayerState receiverState = this.playerStateManager.getState(spectatingPlayer.func_110124_au());
                ClientConnection connection = this.getConnection(receiverState.getUuid());
                if (connection == null) {
                    return;
                }
                GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getUuid(), packet.getData(), packet.getSequenceNumber(), null);
                if (!PluginManager.instance().onSoundPacket(sender, senderState, spectatingPlayer, receiverState, groupSoundPacket, "spectator")) {
                    this.sendSoundPacket(spectatingPlayer, connection, groupSoundPacket);
                }
                return;
            }
            if (Voicechat.SERVER_CONFIG.spectatorInteraction.get().booleanValue()) {
                soundPacket = new LocationSoundPacket(sender.func_110124_au(), sender.func_174824_e(1.0f), packet.getData(), packet.getSequenceNumber(), distance, null);
                source = "spectator";
            }
        }
        if (soundPacket == null) {
            float crouchMultiplayer = sender.func_70093_af() ? Voicechat.SERVER_CONFIG.crouchDistanceMultiplier.get().floatValue() : 1.0f;
            float whisperMultiplayer = packet.isWhispering() ? Voicechat.SERVER_CONFIG.whisperDistanceMultiplier.get().floatValue() : 1.0f;
            float multiplier = crouchMultiplayer * whisperMultiplayer;
            soundPacket = new PlayerSoundPacket(sender.func_110124_au(), packet.getData(), packet.getSequenceNumber(), packet.isWhispering(), distance *= multiplier, null);
            source = "proximity";
        }
        this.broadcast(ServerWorldUtils.getPlayersInRange(sender.func_71121_q(), sender.func_174791_d(), this.getBroadcastRange(distance), p -> !p.func_110124_au().equals(sender.func_110124_au())), soundPacket, sender, senderState, group, source);
    }

    public void sendSoundPacket(EntityPlayerMP player, ClientConnection connection, SoundPacket<?> soundPacket) throws Exception {
        if (!PermissionManager.INSTANCE.LISTEN_PERMISSION.hasPermission(player)) {
            CooldownTimer.run("no-listen-" + player.func_110124_au(), 30000L, () -> player.func_146105_b((ITextComponent)new TextComponentTranslation("message.voicechat.no_listen_permission", new Object[0]), true));
            return;
        }
        connection.send(this, new NetworkMessage(soundPacket));
    }

    public double getBroadcastRange(float minRange) {
        double broadcastRange = Voicechat.SERVER_CONFIG.broadcastRange.get();
        if (broadcastRange < 0.0) {
            broadcastRange = Voicechat.SERVER_CONFIG.voiceChatDistance.get() + 1.0;
        }
        return Math.max(broadcastRange, (double)minRange);
    }

    public void broadcast(Collection<EntityPlayerMP> players, SoundPacket<?> packet, @Nullable EntityPlayerMP sender, @Nullable PlayerState senderState, @Nullable ClientGroup group, String source) {
        for (EntityPlayerMP player : players) {
            ClientConnection connection;
            PlayerState state = this.playerStateManager.getState(player.func_110124_au());
            if (state == null || state.isDisabled() || state.isDisconnected() || state.hasGroup() && state.getGroup().equals(group) || (connection = this.getConnection(player.func_146103_bH().getId())) == null) continue;
            try {
                if (PluginManager.instance().onSoundPacket(sender, senderState, player, state, packet, source)) continue;
                this.sendSoundPacket(player, connection, packet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sendKeepAlives() throws Exception {
        long timestamp = System.currentTimeMillis();
        this.connections.values().removeIf(connection -> {
            if (timestamp - connection.getLastKeepAliveResponse() >= (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue() * 10L) {
                this.secrets.remove(connection.getPlayerUUID());
                Voicechat.LOGGER.info("Player {} timed out", (Object)connection.getPlayerUUID());
                EntityPlayerMP player = this.server.func_184103_al().func_177451_a(connection.getPlayerUUID());
                if (player != null) {
                    Voicechat.LOGGER.info("Reconnecting player {}", (Object)player.func_145748_c_().func_150261_e());
                    Voicechat.SERVER.initializePlayerConnection(player);
                } else {
                    Voicechat.LOGGER.warn("Reconnecting player {} failed (Could not find player)", (Object)connection.getPlayerUUID());
                }
                CommonCompatibilityManager.INSTANCE.emitServerVoiceChatDisconnectedEvent(connection.getPlayerUUID());
                PluginManager.instance().onPlayerDisconnected(connection.getPlayerUUID());
                return true;
            }
            return false;
        });
        for (ClientConnection connection2 : this.connections.values()) {
            this.sendPacket(new KeepAlivePacket(), connection2);
        }
    }

    public Map<UUID, ClientConnection> getConnections() {
        return this.connections;
    }

    @Nullable
    public ClientConnection getConnection(UUID playerID) {
        return this.connections.get(playerID);
    }

    public VoicechatSocket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public void sendPacket(Packet<?> packet, ClientConnection connection) throws Exception {
        connection.send(this, new NetworkMessage(packet));
    }

    public PingManager getPingManager() {
        return this.pingManager;
    }

    public PlayerStateManager getPlayerStateManager() {
        return this.playerStateManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public ServerCategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    private class ProcessThread
    extends Thread {
        private boolean running = true;
        private long lastKeepAlive = 0L;

        public ProcessThread() {
            this.setDaemon(true);
            this.setName("VoiceChatPacketProcessingThread");
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Packet<MicPacket> packet;
                    UUID playerUUID;
                    EntityPlayerMP player;
                    NetworkMessage message;
                    RawUdpPacket rawPacket;
                    Server.this.pingManager.checkTimeouts();
                    long keepAliveTime = System.currentTimeMillis();
                    if (keepAliveTime - this.lastKeepAlive > (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue()) {
                        Server.this.sendKeepAlives();
                        this.lastKeepAlive = keepAliveTime;
                    }
                    if ((rawPacket = (RawUdpPacket)Server.this.packetQueue.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                    try {
                        message = NetworkMessage.readPacketServer(rawPacket, Server.this);
                    }
                    catch (Exception e) {
                        CooldownTimer.run("failed_reading_packet", () -> Voicechat.LOGGER.warn("Failed to read packet from {}", (Object)rawPacket.getSocketAddress()));
                        continue;
                    }
                    if (message == null) continue;
                    if (System.currentTimeMillis() - message.getTimestamp() > message.getTTL()) {
                        CooldownTimer.run("ttl", () -> {
                            Voicechat.LOGGER.warn("Dropping voice chat packets! Your Server might be overloaded!");
                            Voicechat.LOGGER.warn("Packet queue has {} packets", (Object)Server.this.packetQueue.size());
                        });
                        continue;
                    }
                    if (message.getPacket() instanceof AuthenticatePacket) {
                        AuthenticatePacket packet2 = (AuthenticatePacket)message.getPacket();
                        UUID secret = (UUID)Server.this.secrets.get(packet2.getPlayerUUID());
                        if (secret != null && secret.equals(packet2.getSecret())) {
                            ClientConnection connection;
                            if (!Server.this.connections.containsKey(packet2.getPlayerUUID())) {
                                connection = new ClientConnection(packet2.getPlayerUUID(), message.getAddress());
                                Server.this.connections.put(packet2.getPlayerUUID(), connection);
                                Voicechat.LOGGER.info("Successfully authenticated player {}", (Object)packet2.getPlayerUUID());
                                player = Server.this.server.func_184103_al().func_177451_a(packet2.getPlayerUUID());
                                if (player != null) {
                                    CommonCompatibilityManager.INSTANCE.emitServerVoiceChatConnectedEvent(player);
                                    PluginManager.instance().onPlayerConnected(player);
                                }
                            } else {
                                connection = Server.this.getConnection(packet2.getPlayerUUID());
                            }
                            Server.this.sendPacket(new AuthenticateAckPacket(), connection);
                        }
                    }
                    if ((playerUUID = message.getSender(Server.this)) == null) continue;
                    ClientConnection conn = Server.this.getConnection(playerUUID);
                    if (message.getPacket() instanceof MicPacket) {
                        packet = (MicPacket)message.getPacket();
                        player = Server.this.server.func_184103_al().func_177451_a(playerUUID);
                        if (player == null) continue;
                        if (!PermissionManager.INSTANCE.SPEAK_PERMISSION.hasPermission(player)) {
                            CooldownTimer.run("no-speak-" + playerUUID, 30000L, () -> player.func_146105_b((ITextComponent)new TextComponentTranslation("message.voicechat.no_speak_permission", new Object[0]), true));
                            continue;
                        }
                        PlayerState state = Server.this.playerStateManager.getState(player.func_110124_au());
                        if (state == null || PluginManager.instance().onMicPacket(player, state, (MicPacket)packet)) continue;
                        Server.this.processMicPacket(player, state, packet);
                        continue;
                    }
                    if (message.getPacket() instanceof PingPacket) {
                        packet = (PingPacket)message.getPacket();
                        Server.this.pingManager.onPongPacket((PingPacket)packet);
                        continue;
                    }
                    if (!(message.getPacket() instanceof KeepAlivePacket)) continue;
                    conn.setLastKeepAliveResponse(System.currentTimeMillis());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void close() {
            this.running = false;
        }
    }
}

