/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.jobs.registry;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.IJob;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public final class JobEntry
extends IForgeRegistryEntry.Impl<JobEntry>
implements IForgeRegistryEntry<JobEntry> {
    private final Function<ICitizenData, IJob<?>> jobProducer;

    public Function<ICitizenData, IJob<?>> getJobProducer() {
        return this.jobProducer;
    }

    private JobEntry(Function<ICitizenData, IJob<?>> jobProducer) {
        this.jobProducer = jobProducer;
    }

    public static final class Builder {
        private Function<ICitizenData, IJob<?>> jobProducer;
        private ResourceLocation registryName;

        public Builder setJobProducer(Function<ICitizenData, IJob<?>> jobProducer) {
            this.jobProducer = jobProducer;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public JobEntry createJobEntry() {
            Validate.notNull(this.jobProducer);
            Validate.notNull((Object)this.registryName);
            return (JobEntry)new JobEntry(this.jobProducer).setRegistryName(this.registryName);
        }
    }
}

