/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemCrafterJobDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class StandardRequestSystemCrafterJobDataStore
implements IRequestSystemCrafterJobDataStore {
    private IToken<?> id;
    private final LinkedList<IToken<?>> queue;
    private final List<IToken<?>> tasks;

    public StandardRequestSystemCrafterJobDataStore(IToken<?> id, LinkedList<IToken<?>> queue, List<IToken<?>> tasks) {
        this.id = id;
        this.queue = queue;
        this.tasks = tasks;
    }

    public StandardRequestSystemCrafterJobDataStore() {
        this(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new LinkedList(), new ArrayList());
    }

    @Override
    public LinkedList<IToken<?>> getQueue() {
        return this.queue;
    }

    @Override
    public List<IToken<?>> getAssignedTasks() {
        return this.tasks;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestSystemCrafterJobDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestSystemCrafterJobDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestSystemCrafterJobDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestSystemCrafterJobDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestSystemCrafterJobDataStore();
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequestSystemCrafterJobDataStore standardRequestSystemCrafterJobDataStore) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("Token", (NBTBase)controller.serialize(standardRequestSystemCrafterJobDataStore.id));
            compound.func_74782_a("List", (NBTBase)standardRequestSystemCrafterJobDataStore.queue.stream().map(controller::serialize).collect(NBTUtils.toNBTTagList()));
            return compound;
        }

        @Override
        @NotNull
        public StandardRequestSystemCrafterJobDataStore deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) throws Throwable {
            IToken token = (IToken)controller.deserialize(nbt.func_74775_l("Token"));
            LinkedList queue = NBTUtils.streamCompound(nbt.func_150295_c("List", 10)).map(nbtTagCompound -> (IToken)controller.deserialize((NBTTagCompound)nbtTagCompound)).collect(Collectors.toCollection(LinkedList::new));
            List<IToken<?>> taskList = NBTUtils.streamCompound(nbt.func_150295_c("AssignedList", 10)).map(nbtTagCompound -> (IToken)controller.deserialize((NBTTagCompound)nbtTagCompound)).collect(Collectors.toList());
            return new StandardRequestSystemCrafterJobDataStore(token, queue, taskList);
        }
    }
}

