/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TreeNode<T> {
    private T data = null;
    private final List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
    private TreeNode<T> parent = null;

    public TreeNode(T data) {
        this.data = data;
    }

    public void addChild(TreeNode<T> child) {
        super.setParent(this);
        this.children.add(child);
    }

    public void addChild(T childData) {
        TreeNode<T> newChild = new TreeNode<T>(childData);
        super.setParent(this);
        this.children.add(newChild);
    }

    public void addChildren(List<TreeNode<T>> moreChildren) {
        for (TreeNode<T> t : moreChildren) {
            super.setParent(this);
        }
        this.children.addAll(moreChildren);
    }

    public List<TreeNode<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    private void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }
}

