/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.client.gui.WindowGuardControl;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScepterGuard
extends AbstractItemMinecolonies {
    private static final String TAG_LAST_POS = "lastPos";

    public ItemScepterGuard() {
        super("scepterGuard");
        this.func_77656_e(2);
        this.field_77777_bU = 1;
    }

    @NotNull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos lastPos;
        NBTTagCompound compound;
        if (worldIn.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        ItemStack scepter = playerIn.func_184586_b(hand);
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new NBTTagCompound());
        }
        if ((compound = scepter.func_77978_p()).func_74764_b(TAG_LAST_POS) && (lastPos = BlockPosUtil.readFromNBT(compound, TAG_LAST_POS)).equals((Object)pos)) {
            playerIn.field_71071_by.func_70304_b(playerIn.field_71071_by.field_70461_c);
            LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolDoubleClick", new Object[0]);
            return EnumActionResult.FAIL;
        }
        return ItemScepterGuard.handleItemUsage(worldIn, pos, compound, playerIn);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @NotNull EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (worldIn.field_72995_K && compound != null) {
            if (!compound.func_74764_b("id")) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            IColonyView colony = IColonyManager.getInstance().getColonyView(compound.func_74762_e("id"), Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
            if (colony == null) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            BlockPos guardTower = BlockPosUtil.readFromNBT(compound, "pos");
            IBuildingView hut = colony.getBuilding(guardTower);
            if (hut instanceof AbstractBuildingGuards.View && playerIn.func_70093_af()) {
                WindowGuardControl window = new WindowGuardControl((AbstractBuildingGuards.View)hut);
                window.open();
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @NotNull
    private static EnumActionResult handleItemUsage(World worldIn, BlockPos pos, NBTTagCompound compound, EntityPlayer playerIn) {
        if (!compound.func_74764_b("id")) {
            return EnumActionResult.FAIL;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(compound.func_74762_e("id"), worldIn);
        if (colony == null) {
            return EnumActionResult.FAIL;
        }
        BlockPos guardTower = BlockPosUtil.readFromNBT(compound, "pos");
        IBuilding hut = colony.getBuildingManager().getBuilding(guardTower);
        if (!(hut instanceof AbstractBuildingGuards)) {
            return EnumActionResult.FAIL;
        }
        IGuardBuilding tower = (IGuardBuilding)hut;
        if (BlockPosUtil.getDistance2D(pos, guardTower) > (long)tower.getPatrolDistance()) {
            LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolClickGuardTooFar", new Object[0]);
            return EnumActionResult.FAIL;
        }
        GuardTask task = GuardTask.values()[compound.func_74762_e("task")];
        ICitizenData citizen = tower.getMainCitizen();
        String name = "";
        if (citizen != null) {
            name = " " + citizen.getName();
        }
        if (task.equals((Object)GuardTask.GUARD)) {
            LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolClickGuard", pos, name);
            tower.setGuardPos(pos);
            playerIn.field_71071_by.func_70304_b(playerIn.field_71071_by.field_70461_c);
        } else {
            if (!compound.func_74764_b(TAG_LAST_POS)) {
                tower.resetPatrolTargets();
            }
            tower.addPatrolTargets(pos);
            LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolClickPatrol", pos, name);
        }
        BlockPosUtil.writeToNBT(compound, TAG_LAST_POS, pos);
        return EnumActionResult.SUCCESS;
    }
}

