/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuildingWorkerView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildingHiringModeMessage
extends AbstractMessage<BuildingHiringModeMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private HiringMode mode;
    private int dimension;

    public BuildingHiringModeMessage() {
    }

    public BuildingHiringModeMessage(@NotNull IBuildingWorkerView building, HiringMode mode) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.mode = mode;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.mode = HiringMode.values()[buf.readInt()];
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.mode.ordinal());
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(BuildingHiringModeMessage message, EntityPlayerMP player) {
        AbstractBuildingWorker building;
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS) && (building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuildingWorker.class)) != null) {
            building.setHiringMode(message.mode);
        }
    }
}

