/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ChangeDeliveryPriorityMessage
extends AbstractMessage<ChangeDeliveryPriorityMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean up;
    private int dimension;

    public ChangeDeliveryPriorityMessage() {
    }

    public ChangeDeliveryPriorityMessage(@NotNull AbstractBuildingView building, boolean up) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getPosition();
        this.up = up;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.up = buf.readBoolean();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBoolean(this.up);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(ChangeDeliveryPriorityMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.ACCESS_HUTS)) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            IBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
            if (building instanceof AbstractBuildingWorker) {
                if (message.up) {
                    building.alterPickUpPriority(1);
                    building.markDirty();
                } else {
                    building.alterPickUpPriority(-1);
                    building.markDirty();
                }
            }
        }
    }
}

