/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class OpenCraftingGUIMessage
extends AbstractMessage<OpenCraftingGUIMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;
    private int gridSize;
    private int dimension;

    public OpenCraftingGUIMessage() {
    }

    public OpenCraftingGUIMessage(@NotNull AbstractBuildingView building, int gridSize) {
        this.buildingId = building.getPosition();
        this.gridSize = gridSize;
        this.colonyId = building.getColony().getID();
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.gridSize = buf.readInt();
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.gridSize);
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(OpenCraftingGUIMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null && OpenCraftingGUIMessage.checkPermissions(colony, player)) {
            BlockPos pos = message.buildingId;
            player.openGui((Object)MineColonies.instance, 0, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    private static boolean checkPermissions(IColony colony, EntityPlayerMP player) {
        return colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS);
    }
}

