/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.moresoundconfig.asm.framework;

import ichttt.mods.moresoundconfig.asm.MSCCoreMod;
import ichttt.mods.moresoundconfig.asm.framework.PatchFailedException;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class AbstractMethodTransformer
implements IClassTransformer,
Opcodes {
    public final String className;
    public final String srgName;
    public final String mcpName;
    public final String methodDesc;
    private final int computeFlags;

    public AbstractMethodTransformer(String className, String srgName, String mcpName, String methodDesc, int computeFlags) {
        this.className = className;
        this.srgName = srgName;
        this.mcpName = mcpName;
        this.methodDesc = methodDesc;
        this.computeFlags = computeFlags;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals(this.className)) {
            return basicClass;
        }
        try {
            return this.findMethodAndPatch(name, transformedName, basicClass);
        }
        catch (PatchFailedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new PatchFailedException(this.className, "No further details available, check log", e);
        }
    }

    private byte[] findMethodAndPatch(String name, String transformedName, byte[] basicClass) {
        MSCCoreMod.LOGGER.info("Starting patch of class {}", (Object)name);
        ClassNode node = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)node, 0);
        boolean found = false;
        for (MethodNode method : node.methods) {
            if (!method.name.equals(this.srgName) && !method.name.equals(this.mcpName) || !method.desc.equals(this.methodDesc)) continue;
            MSCCoreMod.LOGGER.debug("Found correct method {} with desc {}", (Object)this.mcpName, (Object)this.methodDesc);
            found = true;
            if (this.patchMethod(method)) {
                MSCCoreMod.LOGGER.debug("Patch seems to be successful!");
                break;
            }
            MSCCoreMod.LOGGER.fatal("PATCH FAILED!");
            throw new PatchFailedException(transformedName, "The Subtansformer signalized that it could not find the method it's entry point, see log for further info");
        }
        if (!found) {
            MSCCoreMod.LOGGER.fatal("Did not find method (mcp: {} srg: {}) with desc {}", (Object)this.mcpName, (Object)this.srgName, (Object)this.methodDesc);
            throw new PatchFailedException(transformedName, "The method " + this.mcpName + " with the desc " + this.methodDesc + " could not be found");
        }
        ClassWriter writer = new ClassWriter(this.computeFlags);
        node.accept((ClassVisitor)writer);
        byte[] data = writer.toByteArray();
        MSCCoreMod.LOGGER.info("Patch of class {} ended", (Object)name);
        return data;
    }

    protected abstract boolean patchMethod(MethodNode var1) throws PatchFailedException;
}

