/*
 * Decompiled with CFR 0.152.
 */
package rlnt.extracpus.util;

import appeng.api.definitions.IBlockDefinition;
import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.BlockRenderingCustomizer;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBlockBuilder;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.components.IBlockRegistrationComponent;
import appeng.bootstrap.components.IItemRegistrationComponent;
import appeng.bootstrap.components.IPreInitComponent;
import appeng.bootstrap.definitions.TileEntityDefinition;
import appeng.core.AEConfig;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockDefinition;
import appeng.core.features.BlockStackSrc;
import appeng.core.features.IStackSrc;
import appeng.core.features.TileDefinition;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rlnt.extracpus.ExtraCPUs;

public class FeatureFactoryHelper {
    public static IBlockDefinition build(FeatureFactory factory, IBlockBuilder builder) {
        String registryName = FeatureFactoryHelper.getPrivateFieldValue("registryName", String.class, builder);
        TileEntityDefinition tileEntity = FeatureFactoryHelper.getPrivateFieldValue("tileEntityDefinition", TileEntityDefinition.class, builder);
        List bootstrapComponents = FeatureFactoryHelper.getPrivateFieldValue("bootstrapComponents", List.class, builder);
        if (!AEConfig.instance().areFeaturesEnabled((Collection)FeatureFactoryHelper.getPrivateFieldValue("features", EnumSet.class, builder))) {
            return new TileDefinition(registryName, null, null);
        }
        Block block = (Block)FeatureFactoryHelper.getPrivateFieldValue("blockSupplier", Supplier.class, builder).get();
        block.setRegistryName("extracpus", registryName);
        block.func_149663_c("extracpus." + registryName);
        factory.addBootstrapComponent((IBootstrapComponent)((IBlockRegistrationComponent)(side, registry) -> registry.register((IForgeRegistryEntry)block)));
        ItemBlock blockItem = FeatureFactoryHelper.constructItemFromBlock(block, builder);
        if (blockItem != null) {
            blockItem.setRegistryName("extracpus", registryName);
            blockItem.func_77655_b("extracpus." + registryName);
            factory.addBootstrapComponent((IBootstrapComponent)((IItemRegistrationComponent)(side, registry) -> registry.register((IForgeRegistryEntry)blockItem)));
        }
        block.func_149647_a(ExtraCPUs.MOD_TAB);
        if (bootstrapComponents != null) {
            bootstrapComponents.forEach(component -> factory.addBootstrapComponent((IBootstrapComponent)component.apply(block, blockItem)));
        }
        if (tileEntity != null && block instanceof AEBaseTileBlock) {
            ((AEBaseTileBlock)block).setTileEntity(tileEntity.getTileEntityClass());
            if (tileEntity.getName() == null) {
                tileEntity.setName(registryName);
            }
        }
        if (Platform.isClient()) {
            IBlockRendering blockRendering = FeatureFactoryHelper.getPrivateFieldValue("blockRendering", IBlockRendering.class, builder);
            if (block instanceof AEBaseTileBlock) {
                AEBaseTileBlock tile = (AEBaseTileBlock)block;
                FeatureFactoryHelper.invokeApply(blockRendering, factory, block, tile.getTileEntityClass());
            } else {
                FeatureFactoryHelper.invokeApply(blockRendering, factory, block, null);
            }
            if (blockItem != null) {
                IItemRendering itemBlockRendering = FeatureFactoryHelper.getPrivateFieldValue("itemRendering", IItemRendering.class, builder);
                FeatureFactoryHelper.invokeApply(itemBlockRendering, factory, blockItem);
            }
        }
        if (block instanceof AEBaseTileBlock) {
            factory.addBootstrapComponent((IBootstrapComponent)((IPreInitComponent)side -> AEBaseTile.registerTileItem((Class)(tileEntity == null ? ((AEBaseTileBlock)block).getTileEntityClass() : tileEntity.getTileEntityClass()), (IStackSrc)new BlockStackSrc(block, 0, ActivityState.Enabled))));
            if (tileEntity != null) {
                factory.tileEntityComponent.addTileEntity(tileEntity);
            }
            return new TileDefinition(registryName, (AEBaseTileBlock)block, blockItem);
        }
        return new BlockDefinition(registryName, block, blockItem);
    }

    public static IBlockBuilder useCustomModel(final IBlockBuilder builder) {
        builder.rendering(new BlockRenderingCustomizer(){

            @SideOnly(value=Side.CLIENT)
            public void customize(IBlockRendering rendering, IItemRendering itemRendering) {
                ModelResourceLocation model = new ModelResourceLocation(new ResourceLocation("extracpus", (String)FeatureFactoryHelper.getPrivateFieldValue("registryName", String.class, builder)), "inventory");
                itemRendering.model(model).variants(new ResourceLocation[]{model});
            }
        });
        return builder;
    }

    private static <T> T getPrivateFieldValue(String field, Class<T> clazz, Object instance) {
        try {
            Field f = instance.getClass().getDeclaredField(field);
            f.setAccessible(true);
            return (T)f.get(instance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ItemBlock constructItemFromBlock(Block block, IBlockBuilder builder) {
        try {
            Method m = builder.getClass().getDeclaredMethod("constructItemFromBlock", Block.class);
            m.setAccessible(true);
            return (ItemBlock)m.invoke((Object)builder, block);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static void invokeApply(Object instance, Object ... objects) {
        try {
            for (Method m : instance.getClass().getDeclaredMethods()) {
                if (!m.getName().equals("apply")) continue;
                m.setAccessible(true);
                m.invoke(instance, objects);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

