/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.packager;

import com.google.common.collect.Lists;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipePackager
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public static ArrayList<RecipePackager> recipes = new ArrayList();
    private NonNullList<ItemStack> input;
    private ItemStack output = ItemStack.field_190927_a;

    public RecipePackager(ItemStack out, ItemStack in) {
        this(out, new ItemStack[]{in});
    }

    public RecipePackager(ItemStack out, ItemStack[] in) {
        if (in.length > 6 || in.length == 0) {
            throw new IllegalArgumentException("Input array must be length 6 or less");
        }
        this.input = NonNullList.func_191197_a((int)in.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null || in[i].func_190926_b()) continue;
            this.input.set(i, (Object)in[i]);
        }
        this.output = out;
        this.setRegistryName(new ResourceLocation("cyclicmagic", "packager" + UUID.randomUUID().toString() + out.func_77977_a()));
    }

    public NonNullList<ItemStack> getInput() {
        return this.input;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ArrayList inventory = Lists.newArrayList();
        for (int i = 0; i < inv.func_174923_h(); ++i) {
            for (int j = 0; j < inv.func_174922_i(); ++j) {
                ItemStack itemstack = inv.func_70463_b(j, i);
                if (itemstack.func_190926_b()) continue;
                inventory.add(itemstack.func_77946_l());
            }
        }
        int matches = 0;
        block2: for (ItemStack invo : inventory) {
            for (ItemStack recipe : this.getInput()) {
                if (!UtilItemStack.isItemStackEqualIgnoreCount(recipe, invo) || recipe.func_190916_E() > invo.func_190916_E()) continue;
                ++matches;
                continue block2;
            }
        }
        return matches >= this.input.size();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width == 3 && height == 2;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public static void initAllRecipes() {
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150346_d, 4, 1), new ItemStack[]{new ItemStack(Blocks.field_150346_d, 2, 0), new ItemStack(Blocks.field_150351_n, 2)}));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150339_S), new ItemStack(Items.field_151042_j, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Items.field_151042_j), new ItemStack(Items.field_191525_da, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150340_R), new ItemStack(Items.field_151043_k, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151074_bl, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151127_ba, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150402_ci), new ItemStack(Items.field_151044_h, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150451_bX), new ItemStack(Items.field_151137_ax, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150426_aN), new ItemStack(Items.field_151114_aO, 4)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150336_V), new ItemStack(Items.field_151118_aC, 4)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150385_bj), new ItemStack(Items.field_151130_bT, 4)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150371_ca), new ItemStack(Items.field_151128_bU, 4)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150407_cf), new ItemStack(Items.field_151015_O, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150475_bE), new ItemStack(Items.field_151166_bC, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150484_ah), new ItemStack(Items.field_151045_i, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_189877_df), new ItemStack(Items.field_151064_bs, 4)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_189878_dg), new ItemStack(Items.field_151075_bm, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_180399_cE), new ItemStack(Items.field_151123_aH, 9)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_185767_cT), new ItemStack(Items.field_185162_cT, 4)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150435_aG), new ItemStack(Items.field_151119_aD, 4)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150433_aE), new ItemStack(Items.field_151126_ay, 4)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150433_aE), new ItemStack(Blocks.field_150431_aC, 8)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_180397_cI, 1, 0), new ItemStack(Items.field_179562_cC, 4)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150322_A), new ItemStack((Block)Blocks.field_150354_m, 4, 0)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_180395_cM), new ItemStack((Block)Blocks.field_150354_m, 4, 1)));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_150368_y), new ItemStack(Items.field_151100_aR, 9, EnumDyeColor.BLUE.func_176767_b())));
        RecipePackager.addRecipe(new RecipePackager(new ItemStack(Blocks.field_189880_di), new ItemStack(Items.field_151100_aR, 9, EnumDyeColor.WHITE.func_176767_b())));
    }

    public static void addRecipe(RecipePackager rec) {
        recipes.add(rec);
    }
}

