/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.guide;

import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.guide.GuideItem;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;

public class GuideRegistry {
    private static List<GuideItem> items = new ArrayList<GuideItem>();
    private static final String SUFFIX = ".guide";

    public static GuideItem register(Enchantment ench, List<String> args) {
        args.add(ench.func_77324_c().name().toLowerCase().replace("_", " "));
        return GuideRegistry.register(GuideCategory.ENCHANT, Items.field_151134_bR, ench.func_77320_a(), ench.func_77320_a() + SUFFIX, null, args);
    }

    public static GuideItem register(GuideCategory cat, Block block) {
        return GuideRegistry.register(cat, block, null, null);
    }

    public static GuideItem register(GuideCategory cat, Block block, IRecipe recipe, List<String> args) {
        String pageTitle = block.func_149739_a() + ".name";
        String text = block.func_149739_a() + SUFFIX;
        return GuideRegistry.register(cat, Item.func_150898_a((Block)block), pageTitle, text, recipe, args);
    }

    public static GuideItem register(GuideCategory cat, Item item) {
        return GuideRegistry.register(cat, item, (IRecipe)null, null);
    }

    public static GuideItem register(GuideCategory cat, Item item, IRecipe recipe, List<String> args) {
        String pageTitle = item.func_77658_a() + ".name";
        String above = item.func_77658_a() + SUFFIX;
        return GuideRegistry.register(cat, item, pageTitle, above, recipe, args);
    }

    public static GuideItem register(GuideCategory cat, Item icon, String title, String text) {
        return GuideRegistry.register(cat, icon, title, text, null, null);
    }

    public static GuideItem register(GuideCategory cat, Item icon, String title, String text, IRecipe recipes, List<String> args) {
        if (args != null && args.size() > 0) {
            text = UtilChat.lang(text);
            for (int i = 0; i < args.size(); ++i) {
                text = text.replace("$" + i, args.get(i));
            }
        }
        GuideItem itempage = new GuideItem(cat, icon, title, text, recipes);
        items.add(itempage);
        return itempage;
    }

    public static GuideItem register(GuideCategory cat, Item icon, String title) {
        GuideItem itempage = new GuideItem(cat, icon, title, null, null);
        items.add(itempage);
        return itempage;
    }

    public static List<GuideItem> getItems() {
        return items;
    }
}

