/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.util.UtilSound;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSound
implements IMessage,
IMessageHandler<PacketSound, IMessage> {
    private BlockPos pos;
    private String domain;
    private String type;
    private String category;

    public PacketSound() {
    }

    public PacketSound(BlockPos p, SoundEvent t, SoundCategory cat) {
        this.pos = p;
        ResourceLocation r = t.getRegistryName();
        this.domain = r.func_110624_b();
        this.type = r.func_110623_a();
        this.category = cat.func_187948_a();
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        this.type = tags.func_74779_i("t");
        this.domain = tags.func_74779_i("domain");
        this.category = tags.func_74779_i("cat");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74778_a("t", this.type);
        tags.func_74778_a("domain", this.domain);
        tags.func_74778_a("cat", this.category);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketSound message, MessageContext ctx) {
        SoundEvent s;
        EntityPlayer p;
        if (ctx.side == Side.CLIENT && (p = ModCyclic.proxy.getPlayerEntity(ctx)) != null && (s = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(message.domain, message.type))) != null) {
            SoundCategory cat = SoundCategory.func_187950_a((String)message.category);
            if (cat == null) {
                cat = SoundCategory.BLOCKS;
            }
            UtilSound.playSound(p, message.pos, s, cat);
        }
        return null;
    }
}

