/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook.gui;

import com.ferreusveritas.warpbook.WarpBook;
import com.ferreusveritas.warpbook.core.IDeclareWarp;
import com.ferreusveritas.warpbook.gui.WarpButton;
import com.ferreusveritas.warpbook.net.packet.PacketWarp;
import com.ferreusveritas.warpbook.util.CommandUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBook
extends GuiScreen {
    private final EntityPlayer entityPlayer;
    private NBTTagList items;
    private static final ResourceLocation invBg = new ResourceLocation("warpbook", "textures/gui/book.png");
    private int xSize;
    private int ySize;
    private int page;
    private int pageCount;
    private GuiButton next;
    private GuiButton prev;
    private ArrayList<WarpButton> warps;
    private ArrayList<ButtonPos> pos;
    private static final int warpsPerPage = 10;
    private final Supplier<ItemStack> bookBearer;

    public GuiBook(EntityPlayer entityPlayer) {
        this.entityPlayer = entityPlayer;
        this.bookBearer = () -> entityPlayer.func_184614_ca();
    }

    public GuiBook(EntityPlayer entityPlayer, Supplier<ItemStack> bookBearer) {
        this.entityPlayer = entityPlayer;
        this.bookBearer = bookBearer;
    }

    protected ItemStack procureBook() {
        return this.bookBearer.get();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.xSize = 146;
        this.ySize = 180;
        this.page = 0;
        ItemStack heldItem = this.procureBook();
        if (!heldItem.func_77942_o()) {
            heldItem.func_77982_d(new NBTTagCompound());
        }
        this.items = heldItem.func_77978_p().func_150295_c("WarpPages", (int)new NBTTagCompound().func_74732_a());
        if (this.items.func_74745_c() == 0) {
            CommandUtils.showError((ICommandSender)this.entityPlayer, I18n.func_135052_a((String)"help.nopages", (Object[])new Object[0]));
            this.field_146297_k.func_147108_a((GuiScreen)null);
            return;
        }
        this.pos = new ArrayList();
        for (int i = 0; i < this.items.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(this.items.func_150305_b(i));
            if (!(stack.func_77973_b() instanceof IDeclareWarp)) continue;
            if (((IDeclareWarp)stack.func_77973_b()).hasValidData(stack)) {
                this.pos.add(new ButtonPos(i, ((IDeclareWarp)stack.func_77973_b()).getName(this.entityPlayer.func_130014_f_(), stack)));
                continue;
            }
            this.pos.add(new ButtonPos(i, "..."));
        }
        int x = this.field_146294_l / 2 - 48;
        int y = 12 + this.field_146295_m / 2 - this.ySize / 2;
        int n = Math.min(10, this.pos.size());
        this.warps = new ArrayList();
        for (int i = 0; i < n; ++i) {
            WarpButton but = new WarpButton(n, x, y + 14 * i, 96, 12, "");
            this.field_146292_n.add(but);
            this.warps.add(but);
        }
        y = this.field_146295_m / 2 + this.ySize / 2 - 24;
        this.pageCount = (this.pos.size() - 1) / 10;
        if (this.pageCount != 0) {
            this.prev = new NextPageButton(64, x, y, false);
            this.field_146292_n.add(this.prev);
            this.next = new NextPageButton(65, x + 64, y, true);
            this.field_146292_n.add(this.next);
        }
        this.updateButtonStat();
    }

    private void updateButtonStat() {
        this.page = MathHelper.func_76125_a((int)this.page, (int)0, (int)this.pageCount);
        if (this.prev != null) {
            boolean bl = this.prev.field_146125_m = this.page != 0;
        }
        if (this.next != null) {
            this.next.field_146125_m = this.pageCount > this.page;
        }
        int r = this.pos.size() - this.page * 10;
        int n = Math.min(r, 10);
        for (WarpButton wb : this.warps) {
            wb.field_146125_m = false;
        }
        for (int i = 0; i < n; ++i) {
            int j = this.page * 10 + i;
            WarpButton warp = this.warps.get(i);
            warp.field_146127_k = this.pos.get((int)j).id;
            warp.field_146126_j = this.pos.get((int)j).name;
            warp.field_146125_m = true;
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton guiButton) {
        switch (guiButton.field_146127_k) {
            case 64: {
                --this.page;
                this.updateButtonStat();
                break;
            }
            case 65: {
                ++this.page;
                this.updateButtonStat();
                break;
            }
            default: {
                PacketWarp packet = new PacketWarp(guiButton.field_146127_k);
                WarpBook.network.sendToServer((IMessage)packet);
                this.field_146297_k.func_147108_a((GuiScreen)null);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(invBg);
        this.func_73729_b((this.field_146294_l - this.xSize) / 2, (this.field_146295_m - this.ySize) / 2, 20, 1, this.xSize, this.ySize);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"warpbook.dowarp", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - this.ySize / 2 - 12, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        switch (keyCode) {
            case 203: {
                --this.page;
                this.updateButtonStat();
                break;
            }
            case 205: {
                ++this.page;
                this.updateButtonStat();
            }
        }
        if (c == '\u0001' || c == 'e') {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean isForward;

        public NextPageButton(int buttonId, int x, int y, boolean isForwardIn) {
            super(buttonId, x, y, 23, 13, "");
            this.isForward = isForwardIn;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(invBg);
                int i = 0;
                int j = 192;
                if (flag) {
                    i += 23;
                }
                if (!this.isForward) {
                    j += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j, 23, 13);
            }
        }
    }

    private class ButtonPos {
        public int id;
        public String name;

        public ButtonPos(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

