/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook.item;

import com.ferreusveritas.warpbook.WarpBook;
import com.ferreusveritas.warpbook.core.IDeclareWarp;
import com.ferreusveritas.warpbook.core.WarpColors;
import com.ferreusveritas.warpbook.item.IColorable;
import com.ferreusveritas.warpbook.item.WarpItem;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WarpBookItem
extends Item
implements IColorable {
    public WarpBookItem(String name) {
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77625_d(1);
        this.func_77637_a(WarpBook.tabBook);
        this.func_77656_e(0);
    }

    public int func_77626_a(ItemStack itemStack) {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        WarpBook.lastHeldBooks.put(player, itemStack);
        if (player.func_70093_af()) {
            player.openGui((Object)WarpBook.instance, WarpBook.WarpBookInventoryGuiIndex, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else {
            player.openGui((Object)WarpBook.instance, WarpBook.WarpBookWarpGuiIndex, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        try {
            tooltip.add(I18n.func_135052_a((String)"warpbook.booktooltip", (Object[])new Object[]{stack.func_77978_p().func_150295_c("WarpPages", (int)new NBTTagCompound().func_74732_a()).func_74745_c()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return false;
    }

    public static int getRespawnsLeft(ItemStack item) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74765_d("deathPages");
    }

    public static void setRespawnsLeft(ItemStack item, int deaths) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        item.func_77978_p().func_74777_a("deathPages", (short)deaths);
    }

    public static void decrRespawnsLeft(ItemStack item) {
        WarpBookItem.setRespawnsLeft(item, WarpBookItem.getRespawnsLeft(item) - 1);
    }

    public static int getCopyCost(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList items = itemStack.func_77978_p().func_150295_c("WarpPages", (int)new NBTTagCompound().func_74732_a());
        int count = 0;
        for (int i = 0; i < items.func_74745_c(); ++i) {
            ItemStack item = new ItemStack(items.func_150305_b(i));
            if (!((WarpItem)item.func_77973_b()).isWarpCloneable(item)) continue;
            count += item.func_190916_E();
        }
        return count;
    }

    public static ItemStack copyBook(World world, ItemStack book) {
        ItemStack stack = new ItemStack((Item)WarpBook.items.warpBookItem, 1);
        NBTTagList pages = book.func_77978_p().func_150295_c("WarpPages", 10);
        NBTTagList destPages = new NBTTagList();
        for (int i = 0; i < pages.func_74745_c(); ++i) {
            NBTTagCompound page = pages.func_150305_b(i);
            int slot = page.func_74762_e("Slot");
            ItemStack item = new ItemStack(page);
            if (!(item.func_77973_b() instanceof IDeclareWarp) || !((WarpItem)item.func_77973_b()).isWarpCloneable(item)) continue;
            NBTTagCompound tag = new NBTTagCompound();
            item.func_77955_b(tag);
            tag.func_74768_a("Slot", slot);
            destPages.func_74742_a((NBTBase)tag);
        }
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74782_a("WarpPages", (NBTBase)destPages);
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColor(ItemStack stack, int tintIndex) {
        switch (tintIndex) {
            case 0: {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("color")) {
                    return stack.func_77978_p().func_74762_e("color");
                }
                return WarpColors.LEATHER.getColor();
            }
            case 1: {
                return WarpColors.UNBOUND.getColor();
            }
        }
        return -1;
    }
}

