/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook.net.packet;

import com.ferreusveritas.warpbook.WarpBook;
import com.ferreusveritas.warpbook.util.net.NetUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketWarp
implements IMessage,
IMessageHandler<PacketWarp, IMessage> {
    int pageSlot;

    public PacketWarp() {
    }

    public PacketWarp(int pageSlot) {
        this.pageSlot = pageSlot;
    }

    public static ItemStack getPageById(EntityPlayer player, int pageSlot) {
        try {
            NBTTagList stack = WarpBook.lastHeldBooks.get(player).func_77978_p().func_150295_c("WarpPages", 10);
            ItemStack page = new ItemStack(stack.func_150305_b(pageSlot));
            return page;
        }
        catch (ClassCastException e) {
            return ItemStack.field_190927_a;
        }
    }

    public IMessage onMessage(PacketWarp message, MessageContext ctx) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
            EntityPlayer player = NetUtils.getPlayerFromContext(ctx);
            ItemStack page = PacketWarp.getPageById(player, message.pageSlot);
            WarpBook.warpDrive.queueWarp(player, page);
        });
        return null;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pageSlot = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pageSlot);
    }
}

