/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.warpbook.warps;

import com.ferreusveritas.warpbook.core.WarpColors;
import com.ferreusveritas.warpbook.util.MathUtils;
import com.ferreusveritas.warpbook.util.Waypoint;
import com.ferreusveritas.warpbook.warps.Warp;
import java.math.RoundingMode;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WarpPlayer
extends Warp {
    @Override
    public String getName(World world, ItemStack stack) {
        String name;
        if (this.hasValidData(stack) && (name = stack.func_77978_p().func_74779_i("player")) != null) {
            return name;
        }
        return "\u00a74\u00a7kUnbound";
    }

    @Override
    public Waypoint getWaypoint(EntityPlayer player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K && this.hasValidData(stack)) {
            UUID playerID = UUID.fromString(stack.func_77978_p().func_74779_i("playeruuid"));
            EntityPlayerMP playerTo = null;
            List allPlayers = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
            for (EntityPlayerMP playerS : allPlayers) {
                if (!playerS.func_110124_au().equals(playerID)) continue;
                playerTo = playerS;
            }
            if (player != playerTo && playerTo != null) {
                return new Waypoint("", "", MathUtils.round(playerTo.field_70165_t, RoundingMode.DOWN), MathUtils.round(playerTo.field_70163_u, RoundingMode.DOWN), MathUtils.round(playerTo.field_70161_v, RoundingMode.DOWN), playerTo.field_71093_bK);
            }
        }
        return null;
    }

    @Override
    public boolean hasValidData(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("playeruuid");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add("\u00a7a" + this.getName(world, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WarpColors getColor() {
        return WarpColors.PLAYER;
    }
}

