/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.block.ModBlock;
import com.cjm721.overloaded.block.basic.BlockCreativeGenerator;
import com.cjm721.overloaded.block.basic.BlockEnergyExtractor;
import com.cjm721.overloaded.block.basic.BlockInfiniteWaterSource;
import com.cjm721.overloaded.block.basic.BlockItemInterface;
import com.cjm721.overloaded.block.basic.BlockMatterPurifier;
import com.cjm721.overloaded.block.basic.BlockNetherStar;
import com.cjm721.overloaded.block.basic.BlockPlayerInterface;
import com.cjm721.overloaded.block.basic.InDevBlock;
import com.cjm721.overloaded.block.basic.container.BlockInfiniteBarrel;
import com.cjm721.overloaded.block.basic.container.BlockInfiniteCapacitor;
import com.cjm721.overloaded.block.basic.container.BlockInfiniteTank;
import com.cjm721.overloaded.block.basic.hyperTransfer.BlockHyperEnergyReceiver;
import com.cjm721.overloaded.block.basic.hyperTransfer.BlockHyperEnergySender;
import com.cjm721.overloaded.block.basic.hyperTransfer.BlockHyperFluidReceiver;
import com.cjm721.overloaded.block.basic.hyperTransfer.BlockHyperFluidSender;
import com.cjm721.overloaded.block.basic.hyperTransfer.BlockHyperItemReceiver;
import com.cjm721.overloaded.block.basic.hyperTransfer.BlockHyperItemSender;
import com.cjm721.overloaded.block.compressed.BlockCompressed;
import com.cjm721.overloaded.block.compressed.CompressedBlockHandler;
import com.cjm721.overloaded.block.fluid.BlockPureMatterFluid;
import com.cjm721.overloaded.block.reactor.BlockFusionCore;
import com.cjm721.overloaded.proxy.CommonProxy;
import com.cjm721.overloaded.util.CraftingRegistry;
import com.cjm721.overloaded.util.IModRegistrable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModBlocks {
    public static ModBlock basicGenerator;
    private static ModBlock infiniteBarrel;
    private static ModBlock infiniteTank;
    private static ModBlock infiniteCapacitor;
    private static ModBlock hyperItemReceiver;
    private static ModBlock hyperItemSender;
    private static ModBlock hyperFluidReceiver;
    private static ModBlock hyperFluidSender;
    private static ModBlock hyperEnergyReceiver;
    private static ModBlock hyperEnergySender;
    private static ModBlock infiniteWaterSource;
    private static ModBlock energyExtractor;
    public static ModBlock netherStarBlock;
    private static ModBlock playerInterface;
    private static ModBlock itemInterface;
    private static ModBlock matterPurifier;
    private static BlockPureMatterFluid pureMatterFluidBlock;
    private static ModBlock fusionCore;
    public static ModBlock energyInjectorChest;
    public static List<BlockCompressed> compressedBlocks;
    public static ModBlock itemManipulator;
    private static final List<IModRegistrable> registerList;

    public static void init() {
        basicGenerator = ModBlocks.registerFull(new BlockCreativeGenerator());
        infiniteBarrel = ModBlocks.registerFull(new BlockInfiniteBarrel());
        infiniteTank = ModBlocks.registerFull(new BlockInfiniteTank());
        infiniteCapacitor = ModBlocks.registerFull(new BlockInfiniteCapacitor());
        hyperItemReceiver = ModBlocks.registerFull(new BlockHyperItemReceiver());
        hyperItemSender = ModBlocks.registerFull(new BlockHyperItemSender());
        hyperFluidReceiver = ModBlocks.registerFull(new BlockHyperFluidReceiver());
        hyperFluidSender = ModBlocks.registerFull(new BlockHyperFluidSender());
        hyperEnergyReceiver = ModBlocks.registerFull(new BlockHyperEnergyReceiver());
        hyperEnergySender = ModBlocks.registerFull(new BlockHyperEnergySender());
        infiniteWaterSource = ModBlocks.registerFull(new BlockInfiniteWaterSource());
        energyExtractor = ModBlocks.registerFull(new BlockEnergyExtractor());
        netherStarBlock = ModBlocks.registerFull(new BlockNetherStar());
        playerInterface = ModBlocks.registerFull(new BlockPlayerInterface());
        itemInterface = ModBlocks.registerFull(new BlockItemInterface());
        if (Overloaded.cachedConfig.developmentConfig.wipStuff) {
            fusionCore = ModBlocks.registerFull(new BlockFusionCore());
            matterPurifier = ModBlocks.registerFull(new BlockMatterPurifier());
            pureMatterFluidBlock = ModBlocks.registerBlock(new BlockPureMatterFluid());
            for (int i = 0; i < 10; ++i) {
                ModBlocks.registerFull(new InDevBlock("in_dev_block_" + i));
            }
        }
        try {
            compressedBlocks = CompressedBlockHandler.initFromConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while trying to init Compressed Blocks", e);
        }
        for (BlockCompressed block : compressedBlocks) {
            ModBlocks.registerBlock(block);
        }
    }

    private static void addToSecondaryInit(IModRegistrable block) {
        registerList.add(block);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        for (IModRegistrable block : registerList) {
            block.registerModel();
        }
    }

    private static <T extends ModBlock> T registerFull(T block) {
        ModBlocks.registerBlock(block);
        CommonProxy.itemToRegister.add((Item)new ItemBlock(block).setRegistryName(block.getRegistryName()));
        return block;
    }

    private static <T extends Block> T registerBlock(T block) {
        CommonProxy.blocksToRegister.add(block);
        if (block instanceof ModBlock) {
            ((ModBlock)block).baseInit();
        }
        if (block instanceof IModRegistrable) {
            ModBlocks.addToSecondaryInit((IModRegistrable)block);
        }
        return block;
    }

    public static void secondaryCompressedInit() {
        for (BlockCompressed block : compressedBlocks) {
            if (!block.baseBlockInit() || !block.isRecipeEnabled()) continue;
            CraftingRegistry.addShapedRecipe(new ItemStack(Item.func_150898_a((Block)block), 1, 0), "XXX", "XXX", "XXX", Character.valueOf('X'), new ItemStack(block.getBaseBlock(), 1, block.getBaseMeta()));
            CraftingRegistry.addShapelessRecipe(new ItemStack(block.getBaseBlock(), 9, block.getBaseMeta()), new ItemStack(Item.func_150898_a((Block)block), 1, 0));
            for (int meta = 0; meta < block.getMaxCompression() - 1; ++meta) {
                CraftingRegistry.addShapedRecipe(new ItemStack(Item.func_150898_a((Block)block), 1, meta + 1), "XXX", "XXX", "XXX", Character.valueOf('X'), new ItemStack(Item.func_150898_a((Block)block), 1, meta));
                CraftingRegistry.addShapelessRecipe(new ItemStack(Item.func_150898_a((Block)block), 9, meta), new ItemStack(Item.func_150898_a((Block)block), 1, meta + 1));
            }
        }
    }

    static {
        registerList = new LinkedList<IModRegistrable>();
    }
}

