/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.proxy;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.block.ModBlocks;
import com.cjm721.overloaded.config.syncer.ConfigSyncEventHandler;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.item.functional.armor.ArmorEventHandler;
import com.cjm721.overloaded.network.OverloadedGuiHandler;
import com.cjm721.overloaded.network.handler.ConfigSyncHandler;
import com.cjm721.overloaded.network.handler.KeyBindPressedHandler;
import com.cjm721.overloaded.network.handler.NoClipUpdateHandler;
import com.cjm721.overloaded.network.handler.PlayerMessageHandler;
import com.cjm721.overloaded.network.packets.ConfigSyncMessage;
import com.cjm721.overloaded.network.packets.KeyBindPressedMessage;
import com.cjm721.overloaded.network.packets.LeftClickBlockMessage;
import com.cjm721.overloaded.network.packets.MultiArmorSettingsMessage;
import com.cjm721.overloaded.network.packets.NoClipStatusMessage;
import com.cjm721.overloaded.network.packets.RailGunFireMessage;
import com.cjm721.overloaded.network.packets.RailGunSettingsMessage;
import com.cjm721.overloaded.network.packets.RayGunMessage;
import com.cjm721.overloaded.network.packets.RightClickBlockMessage;
import com.cjm721.overloaded.storage.GenericDataStorage;
import com.cjm721.overloaded.util.CapabilityHyperEnergy;
import com.cjm721.overloaded.util.CapabilityHyperFluid;
import com.cjm721.overloaded.util.CapabilityHyperItem;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class CommonProxy {
    public SimpleNetworkWrapper networkWrapper;
    public static final List<Block> blocksToRegister = new LinkedList<Block>();
    public static final List<Item> itemToRegister = new LinkedList<Item>();
    public static Fluid pureMatter;

    public void preInit(FMLPreInitializationEvent event) {
        this.createFluids();
        ModBlocks.init();
        ModItems.init();
        CapabilityHyperItem.register();
        CapabilityHyperEnergy.register();
        CapabilityHyperFluid.register();
        GenericDataStorage.register();
    }

    private void createFluids() {
        String textureName = "blocks/pure_matter";
        ResourceLocation still = new ResourceLocation("overloaded", textureName + "_still");
        pureMatter = new Fluid("pure_matter", still, still).setDensity(3000).setViscosity(6000).setRarity(EnumRarity.EPIC);
        if (!FluidRegistry.registerFluid((Fluid)pureMatter)) {
            pureMatter = FluidRegistry.getFluid((String)"pure_matter");
        }
    }

    public void init(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"blockNetherStar", (Block)ModBlocks.netherStarBlock);
        ModBlocks.secondaryCompressedInit();
        this.networkWrapper = new SimpleNetworkWrapper("overloaded");
        int dis = 0;
        this.networkWrapper.registerMessage(new PlayerMessageHandler<LeftClickBlockMessage>(ModItems.multiTool::leftClickOnBlockServer), LeftClickBlockMessage.class, dis++, Side.SERVER);
        this.networkWrapper.registerMessage(new PlayerMessageHandler<RightClickBlockMessage>(ModItems.multiTool::rightClickWithItem), RightClickBlockMessage.class, dis++, Side.SERVER);
        this.networkWrapper.registerMessage(new PlayerMessageHandler<RayGunMessage>(ModItems.rayGun::handleMessage), RayGunMessage.class, dis++, Side.SERVER);
        this.networkWrapper.registerMessage(new PlayerMessageHandler<MultiArmorSettingsMessage>(ModItems.customHelmet::updateSettings), MultiArmorSettingsMessage.class, dis++, Side.SERVER);
        this.networkWrapper.registerMessage(new PlayerMessageHandler<RailGunFireMessage>(ModItems.railgun::handleFireMessage), RailGunFireMessage.class, dis++, Side.SERVER);
        this.networkWrapper.registerMessage(new PlayerMessageHandler<RailGunSettingsMessage>(ModItems.railgun::handleSettingsMessage), RailGunSettingsMessage.class, dis++, Side.SERVER);
        this.networkWrapper.registerMessage(KeyBindPressedHandler.class, KeyBindPressedMessage.class, dis++, Side.SERVER);
        this.networkWrapper.registerMessage(NoClipUpdateHandler.class, NoClipStatusMessage.class, dis++, Side.CLIENT);
        this.networkWrapper.registerMessage((IMessageHandler)ConfigSyncHandler.INSTANCE, ConfigSyncMessage.class, dis++, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)ModItems.multiTool);
        MinecraftForge.EVENT_BUS.register((Object)ModItems.railgun);
        MinecraftForge.EVENT_BUS.register((Object)new ArmorEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ConfigSyncEventHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Overloaded.instance, (IGuiHandler)new OverloadedGuiHandler());
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : blocksToRegister) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : itemToRegister) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }
}

