/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CombinedFluidHandler
implements IFluidHandler {
    private final Channel channel;
    private final TesseractBlockEntity requester;

    public CombinedFluidHandler(Channel channel, TesseractBlockEntity requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.pushRecurrentCall()) {
            return new IFluidTankProperties[0];
        }
        ArrayList<IFluidTankProperties[]> list = new ArrayList<IFluidTankProperties[]>(this.channel.tesseracts.size());
        int size = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractBlockEntity tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                IFluidTankProperties[] properties = handler.getTankProperties();
                if (properties == null) continue;
                list.add(properties);
                size += properties.length;
            }
        }
        IFluidTankProperties[] properties = new IFluidTankProperties[size];
        int index = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IFluidTankProperties[] arr;
            IFluidTankProperties[] iFluidTankPropertiesArray = arr = (IFluidTankProperties[])iterator.next();
            int n = iFluidTankPropertiesArray.length;
            for (int i = 0; i < n; ++i) {
                IFluidTankProperties tank;
                properties[index] = tank = iFluidTankPropertiesArray[i];
                ++index;
            }
        }
        this.popRecurrentCall();
        return properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        if (!this.requester.canSend(EnumChannelType.FLUID) || resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidStack fluid = resource.copy();
        int amount = 0;
        block0: for (TesseractReference location : this.channel.receivingTesseracts) {
            TesseractBlockEntity tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if ((amount += handler.fill(fluid, doFill)) >= resource.amount) break block0;
                fluid.amount = resource.amount - amount;
            }
        }
        this.popRecurrentCall();
        return amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.pushRecurrentCall()) {
            return null;
        }
        if (!this.requester.canReceive(EnumChannelType.FLUID) || resource == null || resource.amount <= 0) {
            return null;
        }
        FluidStack fluid = resource.copy();
        block0: for (TesseractReference location : this.channel.sendingTesseracts) {
            TesseractBlockEntity tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                FluidStack stack = handler.drain(fluid.copy(), true);
                if (fluid.amount > 0 && resource.isFluidEqual(stack)) {
                    if (doDrain) {
                        handler.drain(fluid.copy(), true);
                    }
                    fluid.amount -= stack.amount;
                }
                if (fluid.amount > 0) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        if (fluid.amount == resource.amount) {
            return null;
        }
        fluid.amount = resource.amount - fluid.amount;
        return fluid;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.pushRecurrentCall()) {
            return null;
        }
        if (!this.requester.canReceive(EnumChannelType.FLUID) || maxDrain <= 0) {
            return null;
        }
        FluidStack fluid = null;
        block0: for (TesseractReference location : this.channel.sendingTesseracts) {
            TesseractBlockEntity tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if (fluid == null) {
                    fluid = handler.drain(maxDrain, doDrain);
                    if (fluid == null || fluid.amount <= 0) {
                        fluid = null;
                        continue;
                    }
                    fluid.amount = maxDrain - fluid.amount;
                    continue;
                }
                FluidStack stack = handler.drain(fluid.copy(), false);
                if (fluid != null && fluid.amount > 0 && fluid.isFluidEqual(stack)) {
                    if (doDrain) {
                        handler.drain(fluid.copy(), true);
                    }
                    fluid.amount -= stack.amount;
                }
                if (fluid.amount > 0) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        if (fluid == null) {
            return null;
        }
        fluid.amount = maxDrain - fluid.amount;
        return fluid;
    }

    private boolean pushRecurrentCall() {
        if (this.requester.recurrentCalls >= 1) {
            return true;
        }
        ++this.requester.recurrentCalls;
        return false;
    }

    private void popRecurrentCall() {
        --this.requester.recurrentCalls;
    }
}

