/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.ResourceLocation;

public class PlayerRenderer {
    private static final Map<UUID, GameProfile> PLAYER_PROFILE_MAP = new HashMap<UUID, GameProfile>();
    private static final HashSet<UUID> FETCH_QUEUE = new HashSet();

    public static void renderPlayerHead(UUID player, int x, int y, int width, int height) {
        ScreenUtils.bindTexture((ResourceLocation)PlayerRenderer.getPlayerSkin(player));
        ScreenUtils.drawTexture((float)x, (float)y, (float)width, (float)height, (float)0.125f, (float)0.125f, (float)0.125f, (float)0.125f);
    }

    public static String getPlayerUsername(UUID player) {
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        return profile == null ? null : profile.getName();
    }

    public static ResourceLocation getPlayerSkin(UUID player) {
        SkinManager skinManager;
        Map map;
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        if (profile != null && (map = (skinManager = ClientUtils.getMinecraft().func_152342_ad()).func_152788_a(profile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return skinManager.func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        return DefaultPlayerSkin.func_177334_a((UUID)player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GameProfile fetchPlayerProfile(UUID player) {
        Object object = PLAYER_PROFILE_MAP;
        synchronized (object) {
            GameProfile profile = PLAYER_PROFILE_MAP.get(player);
            if (profile != null) {
                return profile;
            }
        }
        object = FETCH_QUEUE;
        synchronized (object) {
            if (!FETCH_QUEUE.contains(player)) {
                FETCH_QUEUE.add(player);
                new Thread(() -> {
                    GameProfile profile;
                    boolean success = false;
                    String name = PlayerRenderer.fetchPlayerName(player);
                    if (name != null && (profile = PlayerRenderer.updateGameProfile(new GameProfile(player, name))) != null) {
                        Map<UUID, GameProfile> map = PLAYER_PROFILE_MAP;
                        synchronized (map) {
                            PLAYER_PROFILE_MAP.put(player, profile);
                        }
                        success = true;
                    }
                    if (!success) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    HashSet<UUID> hashSet = FETCH_QUEUE;
                    synchronized (hashSet) {
                        FETCH_QUEUE.remove(player);
                    }
                }, "Tesseract - UUID to username").start();
            }
        }
        return null;
    }

    @Nullable
    private static GameProfile updateGameProfile(@Nullable GameProfile input) {
        if (!(input == null || input.getName() == null || input.getName().isEmpty() || input.isComplete() && input.getProperties().containsKey((Object)"textures"))) {
            GameProfile gameprofile;
            PlayerProfileCache profileCache = PlayerRenderer.getProfileCache();
            MinecraftSessionService sessionService = PlayerRenderer.getSessionService();
            if (profileCache != null && sessionService != null && (gameprofile = profileCache.func_152655_a(input.getName())) != null) {
                Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    gameprofile = sessionService.fillProfileProperties(gameprofile, true);
                }
                return gameprofile;
            }
        }
        return null;
    }

    private static String fetchPlayerName(UUID player) {
        try {
            String s;
            InputStream inputStream = new URL("https://api.mojang.com/user/profiles/" + player + "/names").openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder builder = new StringBuilder();
            while ((s = reader.readLine()) != null) {
                builder.append(s);
            }
            if (builder.length() > 0) {
                JsonArray array = ((JsonObject)Streams.parse((JsonReader)new JsonReader((Reader)new StringReader("{\"array\":" + builder + "}")))).getAsJsonArray("array");
                String latestName = null;
                long changeDate = -1L;
                for (JsonElement element : array) {
                    long date = element.getAsJsonObject().has("changedToAt") ? element.getAsJsonObject().get("changedToAt").getAsLong() : 0L;
                    if (date <= changeDate) continue;
                    latestName = element.getAsJsonObject().get("name").getAsString();
                    changeDate = date;
                }
                if (latestName != null) {
                    return latestName;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static PlayerProfileCache getProfileCache() {
        return ClientUtils.getMinecraft().func_71401_C().func_152358_ax();
    }

    private static MinecraftSessionService getSessionService() {
        return ClientUtils.getMinecraft().func_152347_ac();
    }
}

