/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.tile.station.TileHolographicPlanetSelector;

public class EntityUIPlanet
extends Entity {
    DimensionProperties properties;
    protected TileHolographicPlanetSelector tile;
    protected static final DataParameter<Integer> planetID = EntityDataManager.func_187226_a(EntityUIPlanet.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> scale = EntityDataManager.func_187226_a(EntityUIPlanet.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> selected = EntityDataManager.func_187226_a(EntityUIPlanet.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityUIPlanet(World worldIn, DimensionProperties properties, TileHolographicPlanetSelector tile, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.setProperties(properties);
        this.tile = tile;
    }

    public EntityUIPlanet(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.2f, 0.2f);
    }

    public float getScale() {
        float scale = ((Float)this.field_70180_af.func_187225_a(EntityUIPlanet.scale)).floatValue();
        this.func_70105_a(0.1f * scale, 0.1f * scale);
        return scale;
    }

    public void setScale(float myScale) {
        this.func_70105_a(0.08f * myScale, 0.08f * myScale);
        this.field_70180_af.func_187227_b(scale, (Object)Float.valueOf(myScale));
    }

    @Nullable
    public NBTTagCompound func_189511_e(NBTTagCompound p_189511_1_) {
        return null;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(planetID, (Object)(this.properties == null ? -2147483647 : this.properties.getId()));
        this.field_70180_af.func_187214_a(scale, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(selected, (Object)false);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && this.tile != null) {
            this.tile.selectSystem(this.properties.getId());
        }
        return true;
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public boolean func_70039_c(@Nullable NBTTagCompound compound) {
        return false;
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    public DimensionProperties getProperties() {
        if (this.properties == null && this.getPlanetID() != -2147483647 || this.properties != null && this.getPlanetID() != this.properties.getId()) {
            this.properties = DimensionManager.getInstance().getDimensionProperties(this.getPlanetID());
        }
        return this.properties;
    }

    public int getPlanetID() {
        if (!this.field_70170_p.field_72995_K) {
            return this.properties == null ? -2147483647 : this.properties.getId();
        }
        int planetId = (Integer)this.field_70180_af.func_187225_a(planetID);
        if (this.properties != null && this.properties.getId() != planetId) {
            this.properties = planetId == -2147483647 ? null : DimensionManager.getInstance().getDimensionProperties(planetId);
        }
        return (Integer)this.field_70180_af.func_187225_a(planetID);
    }

    public void setProperties(DimensionProperties properties) {
        this.properties = properties;
        if (properties != null) {
            this.field_70180_af.func_187227_b(planetID, (Object)properties.getId());
        } else {
            this.field_70180_af.func_187227_b(planetID, (Object)-2147483647);
        }
    }

    public void setSelected(boolean isSelected) {
        this.field_70180_af.func_187227_b(selected, (Object)isSelected);
    }

    public boolean isSelected() {
        return (Boolean)this.field_70180_af.func_187225_a(selected);
    }

    public void setPositionPolar(double originX, double originY, double originZ, double radius, double theta) {
        this.func_70107_b(originX += radius * (double)MathHelper.func_76134_b((float)((float)theta)), originY, originZ += radius * (double)MathHelper.func_76126_a((float)((float)theta)));
    }
}

