/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.puredaisy;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import vazkii.botania.client.integration.jei.puredaisy.PureDaisyRecipeWrapper;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class PureDaisyRecipeCategory
implements IRecipeCategory {
    public static final String UID = "botania.pureDaisy";
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;

    public PureDaisyRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 64);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.pureDaisy", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/pureDaisyOverlay.png"), 0, 0, 64, 46);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.overlay.draw(minecraft, 48, 0);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        boolean outputFluid;
        if (!(recipeWrapper instanceof PureDaisyRecipeWrapper)) {
            return;
        }
        boolean inputFluid = !ingredients.getInputs(FluidStack.class).isEmpty();
        boolean bl = outputFluid = !ingredients.getOutputs(FluidStack.class).isEmpty();
        if (inputFluid) {
            recipeLayout.getFluidStacks().init(0, true, 40, 12, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        } else {
            recipeLayout.getItemStacks().init(0, true, 40, 12);
            recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        }
        recipeLayout.getItemStacks().init(1, true, 70, 12);
        recipeLayout.getItemStacks().set(1, ItemBlockSpecialFlower.ofType("puredaisy"));
        if (outputFluid) {
            recipeLayout.getFluidStacks().init(2, false, 99, 12, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(2, (List)ingredients.getOutputs(FluidStack.class).get(0));
        } else {
            recipeLayout.getItemStacks().init(2, false, 99, 12);
            recipeLayout.getItemStacks().set(2, (List)ingredients.getOutputs(ItemStack.class).get(0));
        }
    }

    @Nonnull
    public String getModName() {
        return "Botania";
    }
}

