/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityThrowableCopy;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemKingKey;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class EntityBabylonWeapon
extends EntityThrowableCopy
implements ILightProvider {
    private static final String TAG_CHARGING = "charging";
    private static final String TAG_VARIETY = "variety";
    private static final String TAG_CHARGE_TICKS = "chargeTicks";
    private static final String TAG_LIVE_TICKS = "liveTicks";
    private static final String TAG_DELAY = "delay";
    private static final String TAG_ROTATION = "rotation";
    private static final DataParameter<Boolean> CHARGING = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIETY = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CHARGE_TICKS = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LIVE_TICKS = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DELAY = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityBabylonWeapon(World world) {
        super(world);
    }

    public EntityBabylonWeapon(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.0f, 0.0f);
        this.field_70180_af.func_187214_a(CHARGING, (Object)false);
        this.field_70180_af.func_187214_a(VARIETY, (Object)0);
        this.field_70180_af.func_187214_a(CHARGE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(LIVE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(DELAY, (Object)0);
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
    }

    public boolean func_180427_aV() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        EntityLivingBase thrower = this.getThrower();
        if (!(this.field_70170_p.field_72995_K || thrower != null && thrower instanceof EntityPlayer && !thrower.field_70128_L)) {
            this.func_70106_y();
            return;
        }
        EntityPlayer player = (EntityPlayer)thrower;
        boolean charging = this.isCharging();
        if (!this.field_70170_p.field_72995_K) {
            boolean newCharging;
            ItemStack stack = player == null ? ItemStack.field_190927_a : PlayerHelper.getFirstHeldItem(player, ModItems.kingKey);
            boolean bl = newCharging = !stack.func_190926_b() && ItemKingKey.isCharging(stack);
            if (charging != newCharging) {
                this.setCharging(newCharging);
                charging = newCharging;
            }
        }
        double x = this.field_70159_w;
        double y = this.field_70181_x;
        double z = this.field_70179_y;
        int liveTime = this.getLiveTicks();
        int delay = this.getDelay();
        if (charging &= liveTime == 0) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            int chargeTime = this.getChargeTicks();
            this.setChargeTicks(chargeTime + 1);
            if (this.field_70170_p.field_73012_v.nextInt(20) == 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.babylonSpawn, SoundCategory.PLAYERS, 0.1f, 1.0f + this.field_70170_p.field_73012_v.nextFloat() * 3.0f);
            }
        } else {
            if (liveTime < delay) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            } else if (liveTime == delay && player != null) {
                RayTraceResult lookat = ToolCommons.raytraceFromEntity(this.field_70170_p, (Entity)player, true, 64.0);
                Vector3 playerLook = lookat == null ? new Vector3(player.func_70040_Z()).multiply(64.0).add(Vector3.fromEntity((Entity)player)) : new Vector3((double)lookat.func_178782_a().func_177958_n() + 0.5, (double)lookat.func_178782_a().func_177956_o() + 0.5, (double)lookat.func_178782_a().func_177952_p() + 0.5);
                Vector3 thisVec = Vector3.fromEntityCenter(this);
                Vector3 motionVec = playerLook.subtract(thisVec).normalize().multiply(2.0);
                x = motionVec.x;
                y = motionVec.y;
                z = motionVec.z;
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.babylonAttack, SoundCategory.PLAYERS, 2.0f, 0.1f + this.field_70170_p.field_73012_v.nextFloat() * 3.0f);
            }
            this.setLiveTicks(liveTime + 1);
            if (!this.field_70170_p.field_72995_K) {
                AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70142_S, this.field_70137_T, this.field_70136_U).func_186662_g(2.0);
                List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
                for (EntityLivingBase living : entities) {
                    if (living == thrower || living.field_70737_aN != 0) continue;
                    if (player != null) {
                        living.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 20.0f);
                    } else {
                        living.func_70097_a(DamageSource.field_76377_j, 20.0f);
                    }
                    this.onImpact(new RayTraceResult((Entity)living));
                    return;
                }
            }
        }
        super.func_70071_h_();
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (liveTime > delay) {
            Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, 1.0f, 0.0f, 0.3f, 0.0f);
        }
        if (liveTime > 200 + delay) {
            this.func_70106_y();
        }
    }

    @Override
    protected void onImpact(RayTraceResult pos) {
        EntityLivingBase thrower = this.getThrower();
        if (pos.field_72308_g == null || pos.field_72308_g != thrower) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, false);
            this.func_70106_y();
        }
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound cmp) {
        super.func_70014_b(cmp);
        cmp.func_74757_a(TAG_CHARGING, this.isCharging());
        cmp.func_74768_a(TAG_VARIETY, this.getVariety());
        cmp.func_74768_a(TAG_CHARGE_TICKS, this.getChargeTicks());
        cmp.func_74768_a(TAG_LIVE_TICKS, this.getLiveTicks());
        cmp.func_74768_a(TAG_DELAY, this.getDelay());
        cmp.func_74776_a(TAG_ROTATION, this.getRotation());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound cmp) {
        super.func_70037_a(cmp);
        this.setCharging(cmp.func_74767_n(TAG_CHARGING));
        this.setVariety(cmp.func_74762_e(TAG_VARIETY));
        this.setChargeTicks(cmp.func_74762_e(TAG_CHARGE_TICKS));
        this.setLiveTicks(cmp.func_74762_e(TAG_LIVE_TICKS));
        this.setDelay(cmp.func_74762_e(TAG_DELAY));
        this.setRotation(cmp.func_74760_g(TAG_ROTATION));
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        return Light.builder().pos((Entity)this).color(1.0f, 1.0f, 0.0f).radius(8.0f).build();
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_70180_af.func_187227_b(CHARGING, (Object)charging);
    }

    public int getVariety() {
        return (Integer)this.field_70180_af.func_187225_a(VARIETY);
    }

    public void setVariety(int var) {
        this.field_70180_af.func_187227_b(VARIETY, (Object)var);
    }

    public int getChargeTicks() {
        return (Integer)this.field_70180_af.func_187225_a(CHARGE_TICKS);
    }

    public void setChargeTicks(int ticks) {
        this.field_70180_af.func_187227_b(CHARGE_TICKS, (Object)ticks);
    }

    public int getLiveTicks() {
        return (Integer)this.field_70180_af.func_187225_a(LIVE_TICKS);
    }

    public void setLiveTicks(int ticks) {
        this.field_70180_af.func_187227_b(LIVE_TICKS, (Object)ticks);
    }

    public int getDelay() {
        return (Integer)this.field_70180_af.func_187225_a(DELAY);
    }

    public void setDelay(int delay) {
        this.field_70180_af.func_187227_b(DELAY, (Object)delay);
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rot));
    }
}

