/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IHornHarvestable;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ItemMod;

public class ItemGrassHorn
extends ItemMod {
    private static final int SUBTYPES = 3;

    public ItemGrassHorn() {
        super("grassHorn");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("botania", "vuvuzela"), (stack, worldIn, entityIn) -> stack.func_82833_r().toLowerCase(Locale.ROOT).contains("vuvuzela") ? 1.0f : 0.0f);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 3; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77667_c(par1ItemStack) + par1ItemStack.func_77952_i();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerItemAppendMeta(this, 3, "grassHorn");
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int time) {
        if (!player.field_70170_p.field_72995_K) {
            if (time != this.func_77626_a(stack) && time % 5 == 0) {
                ItemGrassHorn.breakGrass(player.field_70170_p, stack, stack.func_77952_i(), new BlockPos((Entity)player));
            }
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187679_dF, SoundCategory.BLOCKS, 1.0f, 0.001f);
        }
    }

    public static void breakGrass(World world, ItemStack stack, int stackDmg, BlockPos srcPos) {
        IHornHarvestable.EnumHornType type = IHornHarvestable.EnumHornType.getTypeForMeta(stackDmg);
        Random rand = new Random(srcPos.hashCode());
        int range = 12 - stackDmg * 3;
        int rangeY = 3 + stackDmg * 4;
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)srcPos.func_177982_a(-range, -rangeY, -range), (BlockPos)srcPos.func_177982_a(range, rangeY, range))) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!(block instanceof IHornHarvestable ? ((IHornHarvestable)block).canHornHarvest(world, pos, stack, type) : stackDmg == 0 && block instanceof BlockBush && !(block instanceof ISpecialFlower) || stackDmg == 1 && block.isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos) || stackDmg == 2 && block == Blocks.field_150431_aC)) continue;
            coords.add(pos);
        }
        Collections.shuffle(coords, rand);
        int count = Math.min(coords.size(), 32 + stackDmg * 16);
        for (int i = 0; i < count; ++i) {
            BlockPos currCoords = (BlockPos)coords.get(i);
            IBlockState state = world.func_180495_p(currCoords);
            Block block = state.func_177230_c();
            if (block instanceof IHornHarvestable && ((IHornHarvestable)block).hasSpecialHornHarvest(world, currCoords, stack, type)) {
                ((IHornHarvestable)block).harvestByHorn(world, currCoords, stack, type);
                continue;
            }
            block.func_176226_b(world, currCoords, state, 0);
            world.func_175698_g(currCoords);
            if (!ConfigHandler.blockBreakParticles) continue;
            world.func_175718_b(2001, currCoords, Block.func_176210_f((IBlockState)state));
        }
    }
}

