/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.network.messages.AbstractMessage;
import com.ldtteam.structurize.network.messages.SchematicSaveMessage;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class SchematicRequestMessage
extends AbstractMessage<SchematicRequestMessage, IMessage> {
    private String filename;

    public SchematicRequestMessage() {
    }

    public SchematicRequestMessage(String filename) {
        this.filename = filename;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.filename = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.filename);
    }

    @Override
    public void messageOnServerThread(SchematicRequestMessage message, EntityPlayerMP player) {
        InputStream stream = StructureLoadingUtils.getStream(message.filename);
        if (stream == null) {
            Log.getLogger().error("SchematicRequestMessage: file \"" + message.filename + "\" not found");
        } else {
            Log.getLogger().info("Request: player " + player.func_70005_c_() + " is requesting schematic " + message.filename);
            byte[] schematic = StructureLoadingUtils.getStreamAsByteArray(stream);
            Structurize.getNetwork().sendTo((IMessage)new SchematicSaveMessage(schematic, UUID.randomUUID(), 1, 1), player);
        }
    }
}

