/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class UpdateScanToolMessage
extends AbstractMessage<UpdateScanToolMessage, IMessage> {
    private BlockPos from;
    private BlockPos to;

    public UpdateScanToolMessage() {
    }

    public UpdateScanToolMessage(@NotNull BlockPos from, @NotNull BlockPos to) {
        NBTTagCompound compound;
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (stack.func_77973_b() == ModItems.scanTool && (compound = stack.func_77978_p()) != null) {
            BlockPosUtil.writeToNBT(compound, "pos1", from);
            BlockPosUtil.writeToNBT(compound, "pos2", to);
            stack.func_77982_d(compound);
        }
        this.from = from;
        this.to = to;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.from = BlockPosUtil.readFromByteBuf(buf);
        this.to = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.from);
        BlockPosUtil.writeToByteBuf(buf, this.to);
    }

    @Override
    public void messageOnServerThread(UpdateScanToolMessage message, EntityPlayerMP player) {
        NBTTagCompound compound;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == ModItems.scanTool && (compound = stack.func_77978_p()) != null) {
            BlockPosUtil.writeToNBT(compound, "pos1", message.from);
            BlockPosUtil.writeToNBT(compound, "pos2", message.to);
            stack.func_77982_d(compound);
        }
    }
}

