/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block;

import com.gendeathrow.hatchery.block.TileUpgradable;
import com.gendeathrow.hatchery.storage.EnergyStorageRF;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TilePowered
extends TileUpgradable {
    protected EnergyStorageRF energyStorage = new EnergyStorageRF(0);

    public TilePowered(int upgradeSize) {
        super(upgradeSize);
    }

    public final void setEnergyStored(int quantity) {
        this.energyStorage.setEnergyStored(quantity);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.energyStorage.writeToNBT(nbt);
        return nbt;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.extractEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored() > 0;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return TilePowered.this.receiveEnergy(from, maxReceive, simulate);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public int getEnergyStored() {
                    return TilePowered.this.getEnergyStored(from);
                }

                public int getMaxEnergyStored() {
                    return TilePowered.this.getMaxEnergyStored(from);
                }

                public boolean canExtract() {
                    return false;
                }

                public boolean canReceive() {
                    return true;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

